/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.exception.TerminatedException;
import functionplotter.gui.ProgressView;
import java.util.ArrayList;
import java.util.List;

public abstract class Operation
implements Runnable {
    private static AppException exception;
    private static boolean terminated;
    private static ProgressView progressView;
    private static int threadId;
    private static List<Thread> threads;
    private boolean primary;

    protected Operation() {
    }

    public static synchronized boolean isException() {
        return exception != null;
    }

    public static synchronized AppException getException() {
        return exception;
    }

    public static synchronized boolean isTerminated() {
        return terminated;
    }

    public static synchronized boolean isExceptionOrTerminated() {
        return exception != null || terminated;
    }

    public static synchronized ProgressView getProgressView() {
        return progressView;
    }

    public static synchronized void setException(AppException appException, boolean bl) {
        if (bl || exception == null) {
            exception = appException;
        }
    }

    public static synchronized void setTerminated(boolean bl) {
        terminated = bl;
    }

    public static synchronized void setProgressView(ProgressView progressView) {
        Operation.progressView = progressView;
    }

    public static synchronized int getNumThreads() {
        return threads.size();
    }

    public static synchronized int addThread(Thread thread) {
        threads.add(thread);
        return threads.size();
    }

    public static synchronized void removeThread() {
        threads.remove(Thread.currentThread());
        if (threads.isEmpty() && progressView != null) {
            progressView.close();
            progressView = null;
        }
    }

    public static synchronized void throwOnException() throws AppException {
        if (exception != null) {
            throw exception;
        }
    }

    public static synchronized void throwOnTerminated() throws TerminatedException {
        if (terminated) {
            throw new TerminatedException();
        }
    }

    public static synchronized void throwOnExceptionOrTerminated() throws AppException {
        Operation.throwOnException();
        Operation.throwOnTerminated();
    }

    public boolean start() {
        return this.start(false);
    }

    public boolean start(boolean bl) {
        if (terminated) {
            return false;
        }
        Thread thread = new Thread((Runnable)this, "app-" + this.getClass().getName() + "-" + threadId++);
        thread.setDaemon(bl);
        if (Operation.addThread(thread) == 1) {
            this.primary = true;
        }
        thread.start();
        return true;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    static {
        threads = new ArrayList<Thread>();
    }
}

