/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.ValueOutOfBoundsException;
import functionplotter.util.StringUtilities;
import java.math.BigInteger;
import java.util.Arrays;

public class Numeric {
    public static final String BINARY_PREFIX = "0b";
    public static final String HEX_PREFIX = "0x";
    public static final String HEX_DIGITS_UPPER = "0123456789ABCDEF";
    public static final String HEX_DIGITS_LOWER = "0123456789abcdef";
    private static final int PREFIX_LENGTH = 2;
    private static final int DEFAULT_BYTES_PER_LINE = 8;
    private static final int DEFAULT_INTS_PER_LINE = 4;
    private static String hexDigits = "0123456789ABCDEF";

    private Numeric() {
    }

    public static int bytesToIntBE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = byArray[n];
        while (++n < n3) {
            n4 <<= 8;
            n4 |= byArray[n] & 0xFF;
        }
        return n4;
    }

    public static int bytesToUIntBE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        while (n < n3) {
            n4 <<= 8;
            n4 |= byArray[n++] & 0xFF;
        }
        return n4;
    }

    public static int bytesToIntLE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = byArray[--n3];
        while (--n3 >= n) {
            n4 <<= 8;
            n4 |= byArray[n3] & 0xFF;
        }
        return n4;
    }

    public static int bytesToUIntLE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        while (--n3 >= n) {
            n4 <<= 8;
            n4 |= byArray[n3] & 0xFF;
        }
        return n4;
    }

    public static void intToBytesBE(int n, byte[] byArray, int n2, int n3) {
        for (int i = n2 + n3 - 1; i >= n2; --i) {
            byArray[i] = (byte)n;
            n >>>= 8;
        }
    }

    public static void intToBytesLE(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            byArray[i] = (byte)n;
            n >>>= 8;
        }
    }

    public static long bytesToLongBE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        long l = byArray[n];
        while (++n < n3) {
            l <<= 8;
            l |= (long)(byArray[n] & 0xFF);
        }
        return l;
    }

    public static long bytesToULongBE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        long l = 0L;
        while (n < n3) {
            l <<= 8;
            l |= (long)(byArray[n++] & 0xFF);
        }
        return l;
    }

    public static long bytesToLongLE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        long l = byArray[--n3];
        while (--n3 >= n) {
            l <<= 8;
            l |= (long)(byArray[n3] & 0xFF);
        }
        return l;
    }

    public static long bytesToULongLE(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        long l = 0L;
        while (--n3 >= n) {
            l <<= 8;
            l |= (long)(byArray[n3] & 0xFF);
        }
        return l;
    }

    public static void longToBytesBE(long l, byte[] byArray, int n, int n2) {
        for (int i = n + n2 - 1; i >= n; --i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
    }

    public static void longToBytesLE(long l, byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
    }

    public static String byteToHexString(int n) {
        char[] cArray = new char[]{hexDigits.charAt(n >> 4 & 0xF), hexDigits.charAt(n & 0xF)};
        return new String(cArray);
    }

    public static String uIntToBinString(int n, int n2, char c) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        int n3 = n2;
        while (--n3 >= 0) {
            cArray[n3] = (char)((n & 1) + 48);
            if ((n >>>= 1) != 0) continue;
        }
        return new String(cArray);
    }

    public static String uLongToBinString(long l, int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        int n2 = n;
        while (--n2 >= 0) {
            cArray[n2] = (char)((l & 1L) + 48L);
            if ((l >>>= 1) != 0L) continue;
        }
        return new String(cArray);
    }

    public static String uIntToDecString(int n, int n2, char c) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        int n3 = n2;
        while (--n3 >= 0) {
            cArray[n3] = (char)(n % 10 + 48);
            if ((n /= 10) != 0) continue;
        }
        return new String(cArray);
    }

    public static String uLongToDecString(long l) {
        byte[] byArray = new byte[8];
        Numeric.longToBytesBE(l, byArray, 0, byArray.length);
        return new BigInteger(1, byArray).toString();
    }

    public static String uLongToDecString(long l, int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        int n2 = n;
        while (--n2 >= 0) {
            cArray[n2] = (char)(l % 10L + 48L);
            if ((l /= 10L) != 0L) continue;
        }
        return new String(cArray);
    }

    public static void setHexUpper() {
        hexDigits = HEX_DIGITS_UPPER;
    }

    public static void setHexLower() {
        hexDigits = HEX_DIGITS_LOWER;
    }

    public static String uIntToHexString(int n, int n2, char c) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        int n3 = n2;
        while (--n3 >= 0) {
            cArray[n3] = hexDigits.charAt(n & 0xF);
            if ((n >>>= 4) != 0) continue;
        }
        return new String(cArray);
    }

    public static String uIntToPrefixedHexString(int n, int n2, char c) {
        return HEX_PREFIX + Numeric.uIntToHexString(n, n2, c);
    }

    public static String uLongToHexString(long l, int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        int n2 = n;
        while (--n2 >= 0) {
            cArray[n2] = hexDigits.charAt((int)l & 0xF);
            if ((l >>>= 4) != 0L) continue;
        }
        return new String(cArray);
    }

    public static String uLongToPrefixedHexString(long l, int n, char c) {
        return HEX_PREFIX + Numeric.uLongToHexString(l, n, c);
    }

    public static int parseIntBin(String string) {
        BigInteger bigInteger = new BigInteger(string, 2);
        if (bigInteger.bitLength() > 32) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.intValue();
    }

    public static int parseIntDec(String string) {
        BigInteger bigInteger = new BigInteger(string);
        if (bigInteger.bitLength() > 32) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.intValue();
    }

    public static int parseIntHex(String string) {
        BigInteger bigInteger = new BigInteger(string, 16);
        if (bigInteger.bitLength() > 32) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.intValue();
    }

    public static int parseInt(String string) {
        if (string.length() >= 2) {
            String string2 = string.substring(0, 2).toLowerCase();
            if (string2.equals(BINARY_PREFIX)) {
                return Numeric.parseIntBin(string.substring(2));
            }
            if (string2.equals(HEX_PREFIX)) {
                return Numeric.parseIntHex(string.substring(2));
            }
        }
        return Numeric.parseIntDec(string);
    }

    public static int parseUIntBin(String string) {
        BigInteger bigInteger = new BigInteger(string, 2);
        if (bigInteger.signum() < 0) {
            throw new NumberFormatException();
        }
        if (bigInteger.bitLength() > 32) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.intValue();
    }

    public static int parseUIntDec(String string) {
        BigInteger bigInteger = new BigInteger(string);
        if (bigInteger.signum() < 0) {
            throw new NumberFormatException();
        }
        if (bigInteger.bitLength() > 32) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.intValue();
    }

    public static int parseUIntHex(String string) {
        BigInteger bigInteger = new BigInteger(string, 16);
        if (bigInteger.signum() < 0) {
            throw new NumberFormatException();
        }
        if (bigInteger.bitLength() > 32) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.intValue();
    }

    public static int parseUInt(String string) {
        if (string.length() >= 2) {
            String string2 = string.substring(0, 2).toLowerCase();
            if (string2.equals(BINARY_PREFIX)) {
                return Numeric.parseUIntBin(string.substring(2));
            }
            if (string2.equals(HEX_PREFIX)) {
                return Numeric.parseUIntHex(string.substring(2));
            }
        }
        return Numeric.parseUIntDec(string);
    }

    public static int parseUInt(String string, int[] nArray) {
        int n = 0;
        int n2 = 10;
        if (string.length() >= 2) {
            String string2 = string.substring(0, 2).toLowerCase();
            if (string2.equals(BINARY_PREFIX)) {
                n2 = 2;
                n = Numeric.parseUIntBin(string.substring(2));
            } else if (string2.equals(HEX_PREFIX)) {
                n2 = 16;
                n = Numeric.parseUIntHex(string.substring(2));
            }
        }
        if (n2 == 10) {
            n = Numeric.parseUIntDec(string);
        }
        if (nArray != null) {
            nArray[0] = n2;
        }
        return n;
    }

    public static long parseULongBin(String string) {
        BigInteger bigInteger = new BigInteger(string, 2);
        if (bigInteger.signum() < 0) {
            throw new NumberFormatException();
        }
        if (bigInteger.bitLength() > 64) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.longValue();
    }

    public static long parseULongDec(String string) {
        BigInteger bigInteger = new BigInteger(string);
        if (bigInteger.signum() < 0) {
            throw new NumberFormatException();
        }
        if (bigInteger.bitLength() > 64) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.longValue();
    }

    public static long parseULongHex(String string) {
        BigInteger bigInteger = new BigInteger(string, 16);
        if (bigInteger.signum() < 0) {
            throw new NumberFormatException();
        }
        if (bigInteger.bitLength() > 64) {
            throw new ValueOutOfBoundsException();
        }
        return bigInteger.longValue();
    }

    public static long parseULong(String string) {
        if (string.length() >= 2) {
            String string2 = string.substring(0, 2).toLowerCase();
            if (string2.equals(BINARY_PREFIX)) {
                return Numeric.parseULongBin(string.substring(2));
            }
            if (string2.equals(HEX_PREFIX)) {
                return Numeric.parseULongHex(string.substring(2));
            }
        }
        return Numeric.parseULongDec(string);
    }

    public static long parseULong(String string, int[] nArray) {
        long l = 0L;
        int n = 10;
        if (string.length() >= 2) {
            String string2 = string.substring(0, 2).toLowerCase();
            if (string2.equals(BINARY_PREFIX)) {
                n = 2;
                l = Numeric.parseULongBin(string.substring(2));
            } else if (string2.equals(HEX_PREFIX)) {
                n = 16;
                l = Numeric.parseULongHex(string.substring(2));
            }
        }
        if (n == 10) {
            l = Numeric.parseULongDec(string);
        }
        if (nArray != null) {
            nArray[0] = n;
        }
        return l;
    }

    public static String bytesToHexString(byte[] byArray, int n, int n2, int n3, int n4) {
        return Numeric.bytesToHexString(byArray, n, n2, StringUtilities.createCharString(' ', n3), n4, 8);
    }

    public static String bytesToHexString(byte[] byArray, int n, int n2, String string, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder(n2 * 4);
        for (int i = 0; i < n2; ++i) {
            if (n4 != 0 && i % n4 == 0) {
                if (i > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(string);
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Numeric.uIntToPrefixedHexString(byArray[n + i], n3, '0'));
        }
        return stringBuilder.toString();
    }

    public static String intsToHexString(int[] nArray, int n, int n2, int n3, int n4) {
        return Numeric.intsToHexString(nArray, n, n2, StringUtilities.createCharString(' ', n3), n4, 4);
    }

    public static String intsToHexString(int[] nArray, int n, int n2, String string, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder(n2 * 4);
        for (int i = 0; i < n2; ++i) {
            if (n4 != 0 && i % n4 == 0) {
                if (i > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(string);
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Numeric.uIntToPrefixedHexString(nArray[n + i], n3, '0'));
        }
        return stringBuilder.toString();
    }
}

