/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.text.NumberFormat;

public class DoubleRange
implements Cloneable {
    public double lowerLimit;
    public double upperLimit;

    public DoubleRange() {
    }

    public DoubleRange(double d, double d2) {
        this.lowerLimit = d;
        this.upperLimit = d2;
    }

    public DoubleRange(DoubleRange doubleRange) {
        this.lowerLimit = doubleRange.lowerLimit;
        this.upperLimit = doubleRange.upperLimit;
    }

    public DoubleRange(String string) throws IllegalArgumentException, NumberFormatException {
        String[] stringArray = string.split(" *, *", -1);
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        this.lowerLimit = Double.parseDouble(stringArray[0]);
        this.upperLimit = Double.parseDouble(stringArray[1]);
    }

    public DoubleRange clone() {
        try {
            return (DoubleRange)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleRange) {
            DoubleRange doubleRange = (DoubleRange)object;
            return this.lowerLimit == doubleRange.lowerLimit && this.upperLimit == doubleRange.upperLimit;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.lowerLimit);
        return (int)(l ^= Double.doubleToLongBits(this.upperLimit) * 31L) ^ (int)(l >> 32);
    }

    public String toString() {
        return new String(this.lowerLimit + ", " + this.upperLimit);
    }

    public String toString(NumberFormat numberFormat) {
        return new String(numberFormat.format(this.lowerLimit) + ", " + numberFormat.format(this.upperLimit));
    }

    public double getInterval() {
        return this.upperLimit - this.lowerLimit;
    }

    public double getValue(double d) {
        return this.lowerLimit + (this.upperLimit - this.lowerLimit) * d;
    }

    public boolean contains(double d) {
        return d >= this.lowerLimit && d <= this.upperLimit;
    }

    public double nearestValueWithin(double d) {
        return Math.min(Math.max(this.lowerLimit, d), this.upperLimit);
    }
}

