/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.SwingPropertyChangeSupport;

public class Command
implements Action {
    public static final String ENABLED_KEY = "enabled";
    private static final int PROPERTIES_INITIAL_CAPACITY = 8;
    private ActionListener listener;
    private boolean enabled;
    private Map<String, Object> properties;
    private SwingPropertyChangeSupport changeSupport;

    public Command(ActionListener actionListener) {
        this.listener = actionListener;
        this.enabled = true;
        this.properties = new Hashtable<String, Object>(8);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Object getValue(String string) {
        return string.equals(ENABLED_KEY) ? new Boolean(this.enabled) : this.properties.get(string);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void putValue(String string, Object object) {
        Object object2 = this.getValue(string);
        if (string.equals(ENABLED_KEY)) {
            if (!(object instanceof Boolean)) {
                object = Boolean.FALSE;
            }
            this.enabled = (Boolean)object;
        } else if (object == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, object);
        }
        if (this.changeSupport != null && (object2 == null && object != null || object2 != null && !object2.equals(object))) {
            this.changeSupport.firePropertyChange(string, object2, object);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        if (this.enabled != bl) {
            this.enabled = bl;
            if (this.changeSupport != null) {
                this.changeSupport.firePropertyChange(ENABLED_KEY, new Boolean(bl2), new Boolean(bl));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.listener.actionPerformed(actionEvent);
    }
}

