/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.util.Numeric;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalendarTime {
    public static final String UTC_TIME_ZONE_STR = "UTC";
    private static final int NUM_YEAR_DIGITS = 4;
    private static final int NUM_MONTH_DIGITS = 2;
    private static final int NUM_DAY_DIGITS = 2;
    private static final int NUM_HOUR_DIGITS = 2;
    private static final int NUM_MINUTE_DIGITS = 2;
    private static final int NUM_SECOND_DIGITS = 2;
    private static final int NUM_MILLISECOND_DIGITS = 3;
    private static final String DEFAULT_SEPARATOR = " ";

    private CalendarTime() {
    }

    public static String getTimeString() {
        return CalendarTime.timeToString(-1L, DEFAULT_SEPARATOR, false, false);
    }

    public static String getTimeString(char c) {
        return CalendarTime.timeToString(-1L, Character.toString(c), false, false);
    }

    public static String getTimeString(String string) {
        return CalendarTime.timeToString(-1L, string, false, false);
    }

    public static String getTimeString(boolean bl) {
        return CalendarTime.timeToString(-1L, DEFAULT_SEPARATOR, bl, false);
    }

    public static String getTimeString(boolean bl, boolean bl2) {
        return CalendarTime.timeToString(-1L, DEFAULT_SEPARATOR, bl, bl2);
    }

    public static String getTimeString(char c, boolean bl) {
        return CalendarTime.timeToString(-1L, Character.toString(c), bl, false);
    }

    public static String getTimeString(String string, boolean bl) {
        return CalendarTime.timeToString(-1L, string, bl, false);
    }

    public static String timeToString(long l) {
        return CalendarTime.timeToString(l, DEFAULT_SEPARATOR, false, false);
    }

    public static String timeToString(long l, boolean bl) {
        return CalendarTime.timeToString(l, DEFAULT_SEPARATOR, false, bl);
    }

    public static String timeToString(long l, char c) {
        return CalendarTime.timeToString(l, Character.toString(c), false, false);
    }

    public static String timeToString(long l, String string) {
        return CalendarTime.timeToString(l, string, false, false);
    }

    public static String timeToString(long l, boolean bl, boolean bl2) {
        return CalendarTime.timeToString(l, DEFAULT_SEPARATOR, bl, bl2);
    }

    public static String timeToString(long l, char c, boolean bl, boolean bl2) {
        return CalendarTime.timeToString(l, Character.toString(c), bl, bl2);
    }

    public static String timeToString(long l, String string, boolean bl, boolean bl2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (bl2) {
            ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone(UTC_TIME_ZONE_STR));
        }
        if (l >= 0L) {
            gregorianCalendar.setTimeInMillis(l);
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(1), 4, '0'));
        stringBuilder.append('-');
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(2) + 1, 2, '0'));
        stringBuilder.append('-');
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(5), 2, '0'));
        stringBuilder.append(string);
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(11), 2, '0'));
        stringBuilder.append(':');
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(12), 2, '0'));
        stringBuilder.append(':');
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(13), 2, '0'));
        if (bl) {
            stringBuilder.append('.');
            stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(14), 3, '0'));
        }
        return stringBuilder.toString();
    }

    public static String dateToString() {
        return CalendarTime.dateToString(-1L, null);
    }

    public static String dateToString(long l) {
        return CalendarTime.dateToString(l, null);
    }

    public static String dateToString(long l, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (l >= 0L) {
            gregorianCalendar.setTimeInMillis(l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(1), 4, '0'));
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(2) + 1, 2, '0'));
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(5), 2, '0'));
        return stringBuilder.toString();
    }

    public static String hoursMinsToString() {
        return CalendarTime.hoursMinsToString(-1L, null);
    }

    public static String hoursMinsToString(long l) {
        return CalendarTime.hoursMinsToString(l, null);
    }

    public static String hoursMinsToString(long l, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (l >= 0L) {
            gregorianCalendar.setTimeInMillis(l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(11), 2, '0'));
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(Numeric.uIntToDecString(gregorianCalendar.get(12), 2, '0'));
        return stringBuilder.toString();
    }
}

