/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.exception.TempFileException;
import functionplotter.exception.TerminatedException;
import functionplotter.util.FileAttributeUtilities;
import functionplotter.util.FileWritingMode;
import functionplotter.util.ProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBinaryFile {
    private static final String TEMP_FILE_PREFIX = "_$_";
    protected File file;
    protected List<ProgressListener> progressListeners;

    protected AbstractBinaryFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.progressListeners = new ArrayList<ProgressListener>();
    }

    public abstract void writeData(OutputStream var1) throws AppException;

    public byte[] read() throws AppException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, this.file, fileNotFoundException);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file);
            }
            if (this.file.length() > Integer.MAX_VALUE) {
                throw new FileException((AppException.Id)ErrorId.FILE_IS_TOO_LONG, this.file);
            }
            int n = (int)this.file.length();
            try {
                if (fileInputStream.getChannel().tryLock(0L, Long.MAX_VALUE, true) == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file, exception);
            }
            for (ProgressListener object2 : this.progressListeners) {
                if (!object2.isOperationTerminated()) continue;
                throw new TerminatedException();
            }
            Object object = null;
            try {
                object = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FileException((AppException.Id)ErrorId.NOT_ENOUGH_MEMORY, this.file, outOfMemoryError);
            }
            try {
                if (fileInputStream.read((byte[])object) != n) {
                    throw new FileException((AppException.Id)ErrorId.ERROR_READING_FILE, this.file);
                }
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.ERROR_READING_FILE, this.file, iOException);
            }
            for (ProgressListener progressListener : this.progressListeners) {
                progressListener.setProgress(1.0);
            }
            try {
                FileInputStream fileInputStream2 = fileInputStream;
                fileInputStream = null;
                fileInputStream2.close();
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, this.file, iOException);
            }
            return object;
        }
        catch (AppException appException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw appException;
        }
    }

    public void write(FileWritingMode fileWritingMode) throws AppException, IllegalStateException {
        if (!this.isFile()) {
            throw new IllegalStateException();
        }
        boolean bl = false;
        try {
            bl = this.file.exists();
        }
        catch (SecurityException securityException) {
            throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file, securityException);
        }
        if (bl) {
            switch (fileWritingMode) {
                case DIRECT: {
                    this.writeDirect();
                    break;
                }
                case USE_TEMP_FILE: {
                    this.writeUsingTempFile(false);
                    break;
                }
                case USE_TEMP_FILE_PRESERVE_ATTRS: {
                    this.writeUsingTempFile(true);
                }
            }
        } else {
            this.writeDirect();
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    public ProgressListener[] getProgressListeners() {
        return this.progressListeners.toArray(new ProgressListener[this.progressListeners.size()]);
    }

    protected boolean isFile() {
        return this.file != null;
    }

    private void writeDirect() throws AppException {
        FileOutputStream fileOutputStream = null;
        try {
            if (this.file.exists() && !this.file.canWrite()) {
                throw new FileException((AppException.Id)ErrorId.WRITING_NOT_PERMITTED, this.file);
            }
            try {
                fileOutputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, this.file, fileNotFoundException);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file, securityException);
            }
            try {
                if (fileOutputStream.getChannel().tryLock() == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file, exception);
            }
            this.writeData(fileOutputStream);
            try {
                FileOutputStream fileOutputStream2 = fileOutputStream;
                fileOutputStream = null;
                fileOutputStream2.close();
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, this.file);
            }
        }
        catch (AppException appException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw appException;
        }
    }

    private void writeUsingTempFile(boolean bl) throws AppException {
        FileOutputStream fileOutputStream = null;
        File file = null;
        boolean bl2 = false;
        try {
            Object object;
            if (!this.file.isFile()) {
                throw new FileException((AppException.Id)ErrorId.NOT_A_FILE, this.file);
            }
            if (!this.file.canWrite()) {
                throw new FileException((AppException.Id)ErrorId.WRITING_NOT_PERMITTED, this.file);
            }
            try {
                file = File.createTempFile(TEMP_FILE_PREFIX, null, this.file.getAbsoluteFile().getParentFile());
            }
            catch (Exception exception) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_CREATE_TEMPORARY_FILE, (Throwable)exception);
            }
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, file, fileNotFoundException);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file, securityException);
            }
            try {
                if (fileOutputStream.getChannel().tryLock() == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file, exception);
            }
            this.writeData(fileOutputStream);
            try {
                object = fileOutputStream;
                fileOutputStream = null;
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, file);
            }
            object = null;
            if (bl) {
                try {
                    FileAttributeUtilities.copyAttributes(this.file, file);
                }
                catch (FileAttributeUtilities.AttributesException attributesException) {
                    object = attributesException;
                }
            }
            try {
                if (this.file.exists() && !this.file.delete()) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_DELETE_FILE, this.file);
                }
                bl2 = true;
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_DELETE_FILE, this.file);
            }
            try {
                if (!file.renameTo(this.file)) {
                    throw new TempFileException((AppException.Id)ErrorId.FAILED_TO_RENAME_FILE, this.file, file);
                }
            }
            catch (SecurityException securityException) {
                throw new TempFileException((AppException.Id)ErrorId.FAILED_TO_RENAME_FILE, this.file, file);
            }
            if (object != null) {
                throw object;
            }
        }
        catch (AppException appException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                if (!bl2 && file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw appException;
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        FAILED_TO_OPEN_FILE("Failed to open the file."),
        FAILED_TO_CLOSE_FILE("Failed to close the file."),
        FAILED_TO_LOCK_FILE("Failed to lock the file."),
        ERROR_READING_FILE("An error occurred when reading the file."),
        ERROR_WRITING_FILE("An error occurred when writing the file."),
        FILE_ACCESS_NOT_PERMITTED("Access to the file was not permitted."),
        WRITING_NOT_PERMITTED("Writing to the file was not permitted."),
        NOT_A_FILE("The pathname does not specify a file."),
        FAILED_TO_CREATE_TEMPORARY_FILE("Failed to create a temporary file."),
        FAILED_TO_DELETE_FILE("Failed to delete the existing file."),
        FAILED_TO_RENAME_FILE("Failed to rename the temporary file to the specified filename."),
        FILE_IS_TOO_LONG("The file is too long to be read by this program."),
        NOT_ENOUGH_MEMORY("There was not enough memory to read the file.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

