/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.textfield;

import functionplotter.textfield.AbstractTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ConstrainedTextField
extends AbstractTextField {
    private int maxLength;

    public ConstrainedTextField(int n) {
        super(n);
        this.maxLength = n;
    }

    public ConstrainedTextField(int n, String string) {
        this(n);
        this.setText(string);
    }

    public ConstrainedTextField(int n, int n2) {
        super(n2);
        this.maxLength = n == 0 ? Integer.MAX_VALUE : n;
    }

    public ConstrainedTextField(int n, int n2, String string) {
        this(n, n2);
        this.setText(string);
    }

    @Override
    protected Document createDefaultModel() {
        return new ConstrainedTextDocument();
    }

    protected String translateInsertString(String string, int n) {
        return string;
    }

    protected boolean acceptCharacter(char c, int n) {
        return true;
    }

    private class ConstrainedTextDocument
    extends PlainDocument {
        private static final String OFFSET_BEYOND_END_STR = "Offset is beyond end of text";

        private ConstrainedTextDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            int n3;
            int n4 = this.getLength();
            if (n > n4) {
                throw new BadLocationException(OFFSET_BEYOND_END_STR, n);
            }
            String string2 = ConstrainedTextField.this.translateInsertString(string, n);
            char[] cArray = new char[string2.length()];
            int n5 = 0;
            for (n3 = 0; n3 < string2.length(); ++n3) {
                n2 = string2.charAt(n3);
                if (!ConstrainedTextField.this.acceptCharacter((char)n2, n + n5)) continue;
                cArray[n5++] = n2;
            }
            int n6 = n3 = n5 < string2.length() ? 1 : 0;
            if (n4 + n5 > ConstrainedTextField.this.maxLength) {
                n3 = 1;
                if (n5 > ConstrainedTextField.this.maxLength - n) {
                    n5 = ConstrainedTextField.this.maxLength - n;
                }
                if (n5 > 0 && n < n4 && (n2 = n4 + n5 - ConstrainedTextField.this.maxLength) > 0) {
                    this.remove(n4 - n2, n2);
                }
            }
            if (n3 != 0) {
                ConstrainedTextField.this.getToolkit().beep();
            }
            if (n5 > 0) {
                super.insertString(n, new String(cArray, 0, n5), attributeSet);
                ConstrainedTextField.this.setCaretPosition(n + n5);
            }
        }
    }
}

