/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.GuiUtilities;
import functionplotter.gui.TextRendering;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class TitledBorder
extends AbstractBorder {
    public static final Color DEFAULT_BORDER_COLOUR = new Color(160, 160, 160);
    public static final Color DEFAULT_TITLE_BORDER_COLOUR = new Color(224, 144, 88);
    public static final Color DEFAULT_TITLE_BACKGROUND_COLOUR = new Color(240, 224, 176);
    public static final Color DEFAULT_TITLE_FOREGROUND_COLOUR = Color.BLACK;
    private static final int TITLE_HORIZONTAL_MARGIN = 5;
    private static final int TITLE_VERTICAL_MARGIN = 2;
    private static final int DEFAULT_PADDING = 6;
    private String text;
    private Color borderColour;
    private Color titleBorderColour;
    private Color titleBackgroundColour;
    private Color titleForegroundColour;

    public TitledBorder(String string) {
        this(string, DEFAULT_BORDER_COLOUR, DEFAULT_TITLE_BORDER_COLOUR, DEFAULT_TITLE_BACKGROUND_COLOUR, DEFAULT_TITLE_FOREGROUND_COLOUR);
    }

    public TitledBorder(String string, Color color) {
        this(string, color, DEFAULT_TITLE_BORDER_COLOUR, DEFAULT_TITLE_BACKGROUND_COLOUR, DEFAULT_TITLE_FOREGROUND_COLOUR);
    }

    public TitledBorder(String string, Color color, Color color2, Color color3, Color color4) {
        this.text = string;
        this.borderColour = color;
        this.titleBorderColour = color2;
        this.titleBackgroundColour = color3;
        this.titleForegroundColour = color4;
    }

    public static void setPaddedBorder(JComponent jComponent, String string) {
        TitledBorder.setPaddedBorder(jComponent, string, 6, 6, 6, 6);
    }

    public static void setPaddedBorder(JComponent jComponent, String string, int n) {
        TitledBorder.setPaddedBorder(jComponent, string, n, n, n, n);
    }

    public static void setPaddedBorder(JComponent jComponent, String string, int n, int n2) {
        TitledBorder.setPaddedBorder(jComponent, string, n, n2, n, n2);
    }

    public static void setPaddedBorder(JComponent jComponent, String string, int n, int n2, int n3, int n4) {
        jComponent.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(string), BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = 4 + component.getFontMetrics(GuiUtilities.getFont("MAIN")).getHeight();
        insets.bottom = 1;
        insets.left = 1;
        insets.right = 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics = graphics.create();
        graphics.setFont(GuiUtilities.getFont("MAIN"));
        TextRendering.setHints((Graphics2D)graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(this.text);
        int n6 = Math.min(n3, 10 + n5);
        int n7 = Math.min(n4, 4 + fontMetrics.getAscent() + fontMetrics.getDescent());
        graphics.setColor(component.getBackground());
        graphics.fillRect(n, n2, n3, n7);
        boolean bl = component.getComponentOrientation().isLeftToRight();
        graphics.setColor(this.titleBackgroundColour);
        graphics.fillRect(bl ? n : n + n3 - n6, n2, n6, n7);
        graphics.setColor(this.titleForegroundColour);
        graphics.drawString(this.text, bl ? n + 5 : n + n3 - 5 - n5, 2 + fontMetrics.getAscent());
        graphics.setColor(this.borderColour);
        graphics.drawRect(n, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.setColor(this.titleBorderColour);
        if (bl) {
            graphics.drawRect(n, n2, n + n6 - 1, n2 + n7 - 1);
        } else {
            graphics.drawRect(n + n3 - n6, n2, n + n3 - 1, n2 + n7 - 1);
        }
    }

    public Color getBorderColour() {
        return this.borderColour;
    }

    public Color getTitleBorderColour() {
        return this.titleBorderColour;
    }

    public Color getTitleBackgroundColour() {
        return this.titleBackgroundColour;
    }

    public Color getTitleForegroundColour() {
        return this.titleForegroundColour;
    }

    public Dimension getTitleSize(Component component) {
        FontMetrics fontMetrics = component.getFontMetrics(GuiUtilities.getFont("MAIN"));
        return new Dimension(10 + fontMetrics.stringWidth(this.text), 4 + fontMetrics.getAscent() + fontMetrics.getDescent());
    }
}

