/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.Colours;
import functionplotter.gui.GuiUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SelectionList
extends JList
implements FocusListener {
    private int numViewableColumns;

    public SelectionList(int n, int n2) {
        this._init(n, n2, 2, 4);
    }

    public SelectionList(Object[] objectArray, int n, int n2) {
        super(objectArray);
        this._init(n, n2, 2, 4);
    }

    public SelectionList(int n, int n2, int n3, int n4) {
        this._init(n, n2, n3, n4);
    }

    public SelectionList(Object[] objectArray, int n, int n2, int n3, int n4) {
        super(objectArray);
        this._init(n, n2, n3, n4);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.numViewableColumns * ((CellRenderer)this.getCellRenderer()).getColumnWidth(), this.getVisibleRowCount() * this.getFixedCellHeight());
    }

    private void _init(int n, int n2, int n3, int n4) {
        this.numViewableColumns = n;
        CellRenderer cellRenderer = new CellRenderer(n3, n4);
        this.setCellRenderer(cellRenderer);
        this.setFixedCellHeight(cellRenderer.getRowHeight());
        this.setVisibleRowCount(n2);
        this.setBackground(Colours.List.BACKGROUND.getColour());
        this.addFocusListener(this);
    }

    public static class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final int DEFAULT_VERTICAL_MARGIN = 2;
        private static final int DEFAULT_HORIZONTAL_MARGIN = 4;
        private int verticalMargin;
        private int horizontalMargin;

        public CellRenderer(int n, int n2) {
            this.verticalMargin = n;
            this.horizontalMargin = n2;
            GuiUtilities.setFont("MAIN", this);
            this.setOpaque(true);
            this.setFocusable(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBorder(bl2 && jList.getSelectionMode() != 0 ? BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Colours.List.FOCUSED_CELL_BORDER.getColour()), BorderFactory.createEmptyBorder(this.verticalMargin - 1, this.horizontalMargin - 1, this.verticalMargin - 1, this.horizontalMargin - 1)) : BorderFactory.createEmptyBorder(this.verticalMargin, this.horizontalMargin, this.verticalMargin, this.horizontalMargin));
            this.setBackground(bl ? (jList.isFocusOwner() ? Colours.List.FOCUSED_SELECTION_BACKGROUND.getColour() : Colours.List.SELECTION_BACKGROUND.getColour()) : Colours.List.BACKGROUND.getColour());
            this.setForeground(bl ? (jList.isFocusOwner() ? Colours.List.FOCUSED_SELECTION_FOREGROUND.getColour() : Colours.List.SELECTION_FOREGROUND.getColour()) : Colours.List.FOREGROUND.getColour());
            this.setText(object.toString());
            return this;
        }

        public int getColumnWidth() {
            return GuiUtilities.getCharWidth(48, this.getFontMetrics(this.getFont()));
        }

        public int getRowHeight() {
            return 2 * this.verticalMargin + this.getFontMetrics(this.getFont()).getHeight();
        }
    }
}

