/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.Colours;
import functionplotter.gui.CornerKind;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class GuiUtilities {
    private static final String CLASS_NAME_APP_FONT = "functionplotter.AppFont";
    private static final String METHOD_NAME_GET_FONT = "getFont";
    private static final String METHOD_NAME_APPLY = "apply";
    private static final int DEFAULT_BORDER_PADDING = 6;
    private static final int DEFAULT_TEXT_COMPONENT_VERTICAL_MARGIN = 2;
    private static final int DEFAULT_TEXT_COMPONENT_HORIZONAL_MARGIN = 4;
    private static final int DEFAULT_CORNER_SIZE = 24;

    private GuiUtilities() {
    }

    public static int getCharWidth(int n, FontMetrics fontMetrics) {
        return fontMetrics.charWidth(fontMetrics.getFont().canDisplay(n) ? n : fontMetrics.getFont().getMissingGlyphCode());
    }

    public static int getBaselineOffset(int n, FontMetrics fontMetrics) {
        return GuiUtilities.getBaselineOffset(n, fontMetrics, false);
    }

    public static int getBaselineOffset(int n, FontMetrics fontMetrics, boolean bl) {
        return (n - fontMetrics.getAscent() - fontMetrics.getDescent() + (bl ? 1 : 0)) / 2 + fontMetrics.getAscent();
    }

    public static Window getWindow(Component component) {
        return component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
    }

    public static Toolkit getToolkit(Component component) {
        Toolkit toolkit = null;
        if (component != null) {
            toolkit = component.getToolkit();
        }
        try {
            if (toolkit == null) {
                toolkit = Toolkit.getDefaultToolkit();
            }
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
        return toolkit;
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Component component) {
        GraphicsConfiguration graphicsConfiguration = null;
        if (component != null) {
            graphicsConfiguration = component.getGraphicsConfiguration();
        }
        try {
            if (graphicsConfiguration == null) {
                graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return graphicsConfiguration;
    }

    public static Insets getScreenInsets(Component component) {
        GraphicsConfiguration graphicsConfiguration;
        Insets insets = null;
        Toolkit toolkit = GuiUtilities.getToolkit(component);
        if (toolkit != null && (graphicsConfiguration = GuiUtilities.getGraphicsConfiguration(component)) != null) {
            insets = toolkit.getScreenInsets(graphicsConfiguration);
        }
        return insets;
    }

    public static List<Rectangle> getScreenBounds(Component component) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Toolkit toolkit = GuiUtilities.getToolkit(component);
        try {
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    if (toolkit != null) {
                        Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
                        rectangle.x += insets.left;
                        rectangle.y += insets.top;
                        rectangle.width -= insets.left + insets.right;
                        rectangle.height -= insets.top + insets.bottom;
                    }
                    arrayList.add(rectangle);
                }
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return arrayList;
    }

    public static Rectangle getComponentScreenBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        List<Rectangle> list = GuiUtilities.getScreenBounds(component);
        for (Rectangle rectangle2 : list) {
            if (!rectangle2.intersects(rectangle)) continue;
            return rectangle2;
        }
        return list.isEmpty() ? new Rectangle() : new Rectangle(list.get(0));
    }

    public static Rectangle getVirtualScreenBounds() {
        Rectangle rectangle = new Rectangle();
        try {
            GraphicsDevice[] graphicsDeviceArray;
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    rectangle = rectangle.union(graphicsConfiguration.getBounds());
                }
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return rectangle;
    }

    public static Rectangle getVirtualScreenBounds(Component component) {
        if (component == null) {
            return GuiUtilities.getVirtualScreenBounds();
        }
        Rectangle rectangle = new Rectangle();
        for (Rectangle rectangle2 : GuiUtilities.getScreenBounds(component)) {
            rectangle = rectangle.union(rectangle2);
        }
        return rectangle;
    }

    public static Point getLocationWithinScreen(Component component, Point point) {
        return GuiUtilities.getLocationWithinScreen(component, point, CornerKind.TOP_CORNERS, 24);
    }

    public static Point getLocationWithinScreen(Component component, Point point, CornerKind[] cornerKindArray, int n) {
        if (component == null || point == null || cornerKindArray != null && n < 1) {
            throw new IllegalArgumentException();
        }
        Rectangle rectangle = new Rectangle(point, component.getSize());
        List<Rectangle> list = GuiUtilities.getScreenBounds(component);
        if (cornerKindArray == null || cornerKindArray.length == 0) {
            for (Rectangle rectangle2 : list) {
                if (!rectangle2.intersects(rectangle)) continue;
                return rectangle.getLocation();
            }
        } else {
            Rectangle rectangle3;
            for (CornerKind cornerKind : cornerKindArray) {
                rectangle3 = cornerKind.getRectangle(rectangle, n);
                for (Rectangle rectangle4 : list) {
                    if (!rectangle4.contains(rectangle3)) continue;
                    return rectangle.getLocation();
                }
            }
            for (CornerKind cornerKind : cornerKindArray) {
                rectangle3 = cornerKind.getRectangle(rectangle, n);
                for (Rectangle rectangle4 : list) {
                    if (!rectangle4.intersects(rectangle3)) continue;
                    return cornerKind.getLocation(rectangle, rectangle4, n);
                }
            }
        }
        return list.isEmpty() ? new Point() : list.get(0).getLocation();
    }

    public static Point getComponentLocation(Component component, Point point) {
        Rectangle rectangle = GuiUtilities.getComponentScreenBounds(component);
        return new Point(Math.max(rectangle.x, Math.min(point.x, rectangle.x + rectangle.width - component.getWidth())), Math.max(rectangle.y, Math.min(point.y, rectangle.y + rectangle.height - component.getHeight())));
    }

    public static Point getComponentLocation(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = GuiUtilities.getComponentScreenBounds(component);
        int n = component.getWidth();
        int n2 = component.getHeight();
        int n3 = rectangle2.width - n;
        int n4 = rectangle2.height - n2;
        int n5 = rectangle == null ? rectangle2.x + Math.max(0, Math.min(n3 / 2, n3)) : Math.max(rectangle2.x, Math.min(rectangle.x + (rectangle.width - n) / 2, rectangle2.x + n3));
        int n6 = rectangle == null ? rectangle2.y + Math.max(0, Math.min(n4 / 2, n4)) : Math.max(rectangle2.y, Math.min(rectangle.y + (rectangle.height - n2) / 2, rectangle2.y + n4));
        return new Point(n5, n6);
    }

    public static Point getComponentLocation(Component component, Component component2) {
        return GuiUtilities.getComponentLocation(component, component2 == null ? null : component2.getBounds());
    }

    public static Point getComponentLocation(Component component) {
        return GuiUtilities.getComponentLocation(component, (Rectangle)null);
    }

    public static Point getFrameLocation(JFrame jFrame) {
        Point point = null;
        try {
            jFrame.setExtendedState(0);
            return jFrame.getLocation();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return point;
        }
    }

    public static void setAllEnabled(Component component, boolean bl) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                GuiUtilities.setAllEnabled(component2, bl);
            }
        }
        if (component instanceof AbstractButton && ((AbstractButton)component).getAction() != null) {
            ((AbstractButton)component).getAction().setEnabled(bl);
        } else {
            component.setEnabled(bl);
        }
    }

    public static boolean containsFocus(Window window, Component component) {
        Component component2;
        if (window != null && (component2 = window.getFocusOwner()) != null) {
            while (component != null) {
                if (component == component2) {
                    return true;
                }
                component = component.getParent();
            }
        }
        return false;
    }

    public static boolean setFocus(JComponent jComponent) {
        if (jComponent.requestFocusInWindow()) {
            if (jComponent instanceof JSpinner) {
                jComponent = ((JSpinner)jComponent).getEditor();
            }
            if (jComponent instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                jTextComponent.setCaretPosition(jTextComponent.getText().length());
            }
            return true;
        }
        return false;
    }

    public static Font getFont(String string) {
        Font font = null;
        try {
            Class<?> clazz = Class.forName(CLASS_NAME_APP_FONT);
            if (clazz.isEnum()) {
                for (Object obj : clazz.getEnumConstants()) {
                    if (!((Enum)obj).name().equals(string)) continue;
                    font = (Font)clazz.getMethod(METHOD_NAME_GET_FONT, new Class[0]).invoke(obj, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return font;
    }

    public static void setFont(String string, Component component) {
        block3: {
            try {
                Class<?> clazz = Class.forName(CLASS_NAME_APP_FONT);
                if (!clazz.isEnum()) break block3;
                for (Object obj : clazz.getEnumConstants()) {
                    if (!((Enum)obj).name().equals(string)) continue;
                    clazz.getMethod(METHOD_NAME_APPLY, Component.class).invoke(obj, component);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Box.Filler createFiller() {
        return GuiUtilities.createFiller(1, 1);
    }

    public static Box.Filler createFiller(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        return new Box.Filler(dimension, dimension, dimension);
    }

    public static Color scaleColourBrightness(Color color, float f) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return Color.getHSBColor(fArray[0], fArray[1], Math.min(Math.max(0.0f, fArray[2] * f), 1.0f));
    }

    public static void setPaddedLineBorder(JComponent jComponent) {
        GuiUtilities.setPaddedLineBorder(jComponent, Colours.LINE_BORDER);
    }

    public static void setPaddedLineBorder(JComponent jComponent, int n) {
        GuiUtilities.setPaddedLineBorder(jComponent, n, Colours.LINE_BORDER);
    }

    public static void setPaddedLineBorder(JComponent jComponent, int n, int n2) {
        GuiUtilities.setPaddedLineBorder(jComponent, n, n2, Colours.LINE_BORDER);
    }

    public static void setPaddedLineBorder(JComponent jComponent, int n, int n2, int n3, int n4) {
        GuiUtilities.setPaddedLineBorder(jComponent, n, n2, n3, n4, Colours.LINE_BORDER);
    }

    public static void setPaddedLineBorder(JComponent jComponent, Color color) {
        GuiUtilities.setPaddedLineBorder(jComponent, 6, 6, 6, 6, color);
    }

    public static void setPaddedLineBorder(JComponent jComponent, int n, Color color) {
        GuiUtilities.setPaddedLineBorder(jComponent, n, n, n, n, color);
    }

    public static void setPaddedLineBorder(JComponent jComponent, int n, int n2, Color color) {
        GuiUtilities.setPaddedLineBorder(jComponent, n, n2, n, n2, color);
    }

    public static void setPaddedLineBorder(JComponent jComponent, int n, int n2, int n3, int n4, Color color) {
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    public static void setPaddedRaisedBevelBorder(JComponent jComponent) {
        GuiUtilities.setPaddedRaisedBevelBorder(jComponent, 6, 6, 6, 6);
    }

    public static void setPaddedRaisedBevelBorder(JComponent jComponent, int n) {
        GuiUtilities.setPaddedRaisedBevelBorder(jComponent, n, n, n, n);
    }

    public static void setPaddedRaisedBevelBorder(JComponent jComponent, int n, int n2) {
        GuiUtilities.setPaddedRaisedBevelBorder(jComponent, n, n2, n, n2);
    }

    public static void setPaddedRaisedBevelBorder(JComponent jComponent, int n, int n2, int n3, int n4) {
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    public static void setViewportBorder(JScrollPane jScrollPane, int n, int n2) {
        jScrollPane.setViewportBorder(BorderFactory.createMatteBorder(n, n2, n, n2, jScrollPane.getViewport().getView().getBackground()));
    }

    public static void setTextComponentMargins(JTextComponent jTextComponent) {
        GuiUtilities.setTextComponentMargins(jTextComponent, 2, 4);
    }

    public static void setTextComponentMargins(JTextComponent jTextComponent, int n, int n2) {
        Insets insets = jTextComponent.getMargin();
        insets.set(Math.max(n, insets.top), Math.max(n2, insets.left), Math.max(n, insets.bottom), Math.max(n2, insets.right));
        jTextComponent.setMargin(insets);
    }
}

