/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.Colours;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;

public class ArrowButton
extends JButton {
    public static final Color BORDER_COLOUR = Color.GRAY;
    public static final Color FOCUSED_BORDER_COLOUR = new Color(128, 128, 160);
    public static final Color BACKGROUND_COLOUR = new Color(184, 216, 184);
    public static final Color ACTIVE_BACKGROUND_COLOUR = Colours.FOCUSED_SELECTION_BACKGROUND;
    public static final Color DISABLED_BACKGROUND_COLOUR = new Color(208, 208, 208);
    public static final Color FOREGROUND_COLOUR = Colours.FOREGROUND;
    public static final Color DISABLED_FOREGROUND_COLOUR = new Color(144, 144, 144);
    private static final int MIN_WIDTH = 1;
    private static final int MAX_WIDTH = Short.MAX_VALUE;
    private static final int MIN_HEIGHT = 1;
    private static final int MAX_HEIGHT = Short.MAX_VALUE;
    private static final int MIN_ARROW_SIZE = 1;
    private static final int MAX_ARROW_SIZE = Short.MAX_VALUE;
    private int width;
    private int height;
    private int arrowSize;
    private Direction direction;
    private boolean bar;
    private Active active;

    public ArrowButton(int n, int n2, int n3) throws IllegalArgumentException {
        this(n, n2, n3, null, false);
    }

    public ArrowButton(int n, int n2, int n3, Direction direction) throws IllegalArgumentException {
        this(n, n2, n3, direction, false);
    }

    public ArrowButton(int n, int n2, int n3, boolean bl) throws IllegalArgumentException {
        this(n, n2, n3, null, bl);
    }

    public ArrowButton(int n, int n2, int n3, Direction direction, boolean bl) throws IllegalArgumentException {
        if (n < 1 || n > Short.MAX_VALUE || n2 < 1 || n2 > Short.MAX_VALUE || n3 < 1 || n3 > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.width = n;
        this.height = n2;
        this.arrowSize = n3;
        this.direction = direction;
        this.bar = bl;
        this.active = Active.ARMED;
        this.setBorder(null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.isEnabled() ? (this.isActive() ? ACTIVE_BACKGROUND_COLOUR : BACKGROUND_COLOUR) : DISABLED_BACKGROUND_COLOUR);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.direction != null) {
            graphics.setColor(this.isEnabled() ? FOREGROUND_COLOUR : DISABLED_FOREGROUND_COLOUR);
            switch (this.direction) {
                case UP: {
                    int n;
                    int n2 = n = (this.width - 1) / 2;
                    int n3 = (this.height - this.arrowSize) / 2;
                    if (this.bar) {
                        n3 += 2;
                    }
                    for (int i = 0; i < this.arrowSize; ++i) {
                        graphics.drawLine(n, n3, n2, n3);
                        --n;
                        ++n2;
                        ++n3;
                    }
                    if (!this.bar) break;
                    graphics.drawLine(++n, n3 -= this.arrowSize + 3, --n2, n3);
                    graphics.drawLine(n, ++n3, n2, n3);
                    break;
                }
                case DOWN: {
                    int n;
                    int n4 = n = (this.width - 1) / 2;
                    int n5 = this.height - 1 - (this.height - this.arrowSize) / 2;
                    if (this.bar) {
                        n5 -= 2;
                    }
                    for (int i = 0; i < this.arrowSize; ++i) {
                        graphics.drawLine(n, n5, n4, n5);
                        --n;
                        ++n4;
                        --n5;
                    }
                    if (!this.bar) break;
                    graphics.drawLine(++n, n5 += this.arrowSize + 3, --n4, n5);
                    graphics.drawLine(n, --n5, n4, n5);
                    break;
                }
                case LEFT: {
                    int n;
                    int n6 = (this.width - this.arrowSize) / 2;
                    if (this.bar) {
                        n6 += 2;
                    }
                    int n7 = n = (this.height - 1) / 2;
                    for (int i = 0; i < this.arrowSize; ++i) {
                        graphics.drawLine(n6, n, n6, n7);
                        ++n6;
                        --n;
                        ++n7;
                    }
                    if (!this.bar) break;
                    graphics.drawLine(n6 -= this.arrowSize + 3, ++n, n6, --n7);
                    graphics.drawLine(++n6, n, n6, n7);
                    break;
                }
                case RIGHT: {
                    int n;
                    int n8 = this.width - 1 - (this.width - this.arrowSize) / 2;
                    if (this.bar) {
                        n8 -= 2;
                    }
                    int n9 = n = (this.height - 1) / 2;
                    for (int i = 0; i < this.arrowSize; ++i) {
                        graphics.drawLine(n8, n, n8, n9);
                        --n8;
                        --n;
                        ++n9;
                    }
                    if (!this.bar) break;
                    graphics.drawLine(n8 += this.arrowSize + 3, ++n, n8, --n9);
                    graphics.drawLine(--n8, n, n8, n9);
                    break;
                }
            }
        }
        if (this.isFocusOwner()) {
            graphics.setColor(FOCUSED_BORDER_COLOUR);
            graphics.drawRect(1, 1, this.width - 3, this.height - 3);
        } else {
            graphics.setColor(BORDER_COLOUR);
        }
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isBar() {
        return this.bar;
    }

    public boolean isActive() {
        if (this.active != null) {
            switch (this.active) {
                case PRESSED: {
                    return this.getModel().isPressed();
                }
                case ARMED: {
                    return this.getModel().isArmed();
                }
            }
        }
        return false;
    }

    public void setDirection(Direction direction) {
        if (this.direction != direction) {
            this.direction = direction;
            this.repaint();
        }
    }

    public void setActive(Active active) {
        if (this.active != active) {
            this.active = active;
            this.repaint();
        }
    }

    public static enum Active {
        PRESSED,
        ARMED;

    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

