/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.AppConfig;
import functionplotter.FunctionDocument;
import functionplotter.exception.AppException;
import functionplotter.exception.TerminatedException;
import java.io.File;
import java.util.List;

abstract class Operation
extends functionplotter.util.Operation {
    private Operation() {
    }

    public static class WriteConfig
    extends Operation {
        private File file;

        public WriteConfig(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                AppConfig.getInstance().write(this.file);
            }
            catch (TerminatedException terminatedException) {
            }
            catch (AppException appException) {
                WriteConfig.setException(appException, false);
            }
            WriteConfig.removeThread();
        }
    }

    public static class WriteImage
    extends Operation {
        private FunctionDocument document;
        private File file;

        public WriteImage(FunctionDocument functionDocument, File file) {
            this.document = functionDocument;
            this.file = file;
        }

        @Override
        public void run() {
            try {
                this.document.writeImage(this.file);
            }
            catch (TerminatedException terminatedException) {
            }
            catch (AppException appException) {
                WriteImage.setException(appException, false);
            }
            WriteImage.removeThread();
        }
    }

    public static class WriteDocument
    extends Operation {
        private FunctionDocument document;
        private FunctionDocument.FileEx fileEx;
        private boolean includeColours;

        public WriteDocument(FunctionDocument functionDocument, FunctionDocument.FileEx fileEx, boolean bl) {
            this.document = functionDocument;
            this.fileEx = fileEx;
            this.includeColours = bl;
        }

        @Override
        public void run() {
            try {
                this.document.write(this.fileEx, this.includeColours);
            }
            catch (TerminatedException terminatedException) {
            }
            catch (AppException appException) {
                WriteDocument.setException(appException, false);
            }
            WriteDocument.removeThread();
        }
    }

    public static class ReadDocument
    extends Operation {
        private FunctionDocument document;
        private File file;
        private List<String> errorStrs;

        public ReadDocument(FunctionDocument functionDocument, File file, List<String> list) {
            this.document = functionDocument;
            this.file = file;
            this.errorStrs = list;
        }

        @Override
        public void run() {
            try {
                this.document.read(this.file, this.errorStrs);
            }
            catch (AppException appException) {
                ReadDocument.setException(appException, false);
            }
            ReadDocument.removeThread();
        }
    }
}

