/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.Expression;
import java.awt.Color;

class Function
implements Cloneable {
    public static final char SEPARATOR_CHAR = ';';
    private Color colour;
    private Expression expression;
    private boolean visible;

    public Function(Color color, Expression expression) {
        this(color, expression, true);
    }

    public Function(Color color, Expression expression, boolean bl) {
        this.colour = color;
        this.expression = expression;
        this.visible = bl;
    }

    public Function clone() {
        try {
            Function function = (Function)super.clone();
            function.colour = new Color(this.colour.getRGB());
            try {
                function.expression = new Expression(this.expression.toString());
            }
            catch (Expression.Exception exception) {
                // empty catch block
            }
            return function;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Function) {
            Function function = (Function)object;
            return this.colour.equals(function.colour) && this.expression.equals(function.expression);
        }
        return false;
    }

    public int hashCode() {
        return this.colour.hashCode() * 31 + this.expression.hashCode();
    }

    public String toString() {
        return this.expression.toString();
    }

    public Color getColour() {
        return this.colour;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

