/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.gui.FButton;
import functionplotter.gui.FTextArea2;
import functionplotter.gui.GuiUtilities;
import functionplotter.util.KeyAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

class CommentDialog
extends JDialog
implements ActionListener {
    private static final int COMMENT_AREA_NUM_ROWS = 16;
    private static final int COMMENT_AREA_NUM_COLUMNS = 80;
    private static final int COMMENT_AREA_VERTICAL_MARGIN = 2;
    private static final int COMMENT_AREA_HORIZONTAL_MARGIN = 4;
    private static Point location;
    private JTextArea commentArea;
    private boolean accepted;

    private CommentDialog(Window window, String string, String string2) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.setIconImages(window.getIconImages());
        this.commentArea = new FTextArea2(string2);
        JScrollPane jScrollPane = new JScrollPane(this.commentArea, 22, 32);
        FontMetrics fontMetrics = this.commentArea.getFontMetrics(this.commentArea.getFont());
        int n = 80 * GuiUtilities.getCharWidth(48, fontMetrics);
        int n2 = 16 * fontMetrics.getHeight();
        jScrollPane.getViewport().setPreferredSize(new Dimension(n, n2));
        GuiUtilities.setViewportBorder(jScrollPane, 2, 4);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 8, 3, 8));
        FButton fButton = new FButton("OK");
        fButton.setActionCommand("accept");
        fButton.addActionListener(this);
        jPanel.add(fButton);
        FButton fButton2 = new FButton("Cancel");
        fButton2.setActionCommand("close");
        fButton2.addActionListener(this);
        jPanel.add(fButton2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        int n3 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        KeyAction.create(jPanel2, 1, KeyStroke.getKeyStroke(27, 0), "close", this);
        this.setContentPane(jPanel2);
        App.applyOrientationByLocale(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            location = GuiUtilities.getComponentLocation((Component)this, window);
        }
        this.setLocation(location);
        this.getRootPane().setDefaultButton(fButton);
        this.commentArea.requestFocusInWindow();
        this.commentArea.setCaretPosition(this.commentArea.getText().length());
        this.setVisible(true);
    }

    public static String showDialog(Component component, String string, String string2) {
        return new CommentDialog(GuiUtilities.getWindow(component), string, string2).getComment();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("accept")) {
            this.doAccept();
        } else if (string.equals("close")) {
            this.doClose();
        }
    }

    private String getComment() {
        return this.accepted ? this.commentArea.getText().trim() : null;
    }

    private void doAccept() {
        this.accepted = true;
        this.doClose();
    }

    private void doClose() {
        location = this.getLocation();
        this.setVisible(false);
        this.dispose();
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CommentDialog.this.doClose();
        }
    }

    private static interface Command {
        public static final String ACCEPT = "accept";
        public static final String CLOSE = "close";
    }
}

