/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.svg.SVGRenderer;
import org.apache.fop.render.svg.SVGRendererContextConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGSVGHandler
implements XMLHandler,
SVGRendererContextConstants {
    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        if (this.getNamespace().equals(ns)) {
            if (!(doc instanceof SVGDocument)) {
                DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
                doc = DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl);
            }
            SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
            SVGDocument targetDoc = (SVGDocument)context.getProperty("svgDoc");
            SVGElement currentPageG = (SVGElement)context.getProperty("svgPageG");
            Element view = targetDoc.createElementNS(this.getNamespace(), "svg");
            Node newsvg = targetDoc.importNode((Node)svg, true);
            int xpos = (Integer)context.getProperty("xpos");
            int ypos = (Integer)context.getProperty("ypos");
            view.setAttributeNS(null, "x", "" + (float)xpos / 1000.0f);
            view.setAttributeNS(null, "y", "" + (float)ypos / 1000.0f);
            Element ele = (Element)newsvg;
            ele.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.getNamespace());
            if (ele.hasAttributeNS(null, "xmlns")) {
                ele.removeAttributeNS(null, "xmlns");
            }
            view.appendChild(newsvg);
            currentPageG.appendChild((Node)view);
        }
    }

    public boolean supportsRenderer(Renderer renderer) {
        return renderer instanceof SVGRenderer;
    }

    public String getNamespace() {
        return "image/svg+xml";
    }
}

