/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MIFElement {
    protected String name;
    protected String valueStr = null;
    protected List valueElements = null;
    protected boolean started = false;
    protected boolean finish = false;
    protected boolean finished = false;

    public MIFElement(String name) {
        this.name = name;
    }

    public void setValue(String str) {
        this.valueStr = str;
    }

    public void addElement(MIFElement el) {
        if (this.valueElements == null) {
            this.valueElements = new ArrayList();
        }
        this.valueElements.add(el);
    }

    public boolean output(OutputStream os, int indent) throws IOException {
        if (this.finished) {
            return true;
        }
        if (this.valueElements == null && this.valueStr == null) {
            return false;
        }
        String indentStr = "";
        for (int c = 0; c < indent; ++c) {
            indentStr = indentStr + " ";
        }
        if (!this.started) {
            os.write((indentStr + "<" + this.name).getBytes());
            if (this.valueElements != null) {
                os.write("\n".getBytes());
            }
            this.started = true;
        }
        if (this.valueElements != null) {
            boolean done = true;
            Iterator iter = this.valueElements.iterator();
            while (iter.hasNext()) {
                MIFElement el = (MIFElement)iter.next();
                boolean d = el.output(os, indent + 1);
                if (d) {
                    iter.remove();
                    continue;
                }
                done = false;
                break;
            }
            if (!this.finish || !done) {
                return false;
            }
            os.write((indentStr + "> # end of " + this.name + "\n").getBytes());
        } else {
            os.write((" " + this.valueStr + ">\n").getBytes());
        }
        this.finished = true;
        return true;
    }

    public void finish(boolean deep) {
        this.finish = true;
        if (deep && this.valueElements != null) {
            for (MIFElement el : this.valueElements) {
                el.finish(deep);
            }
        }
    }
}

