/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.JASHist;
import jas.hist.XMLHistBuilder;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class XMLHistViewer
extends JFrame {
    public static final Class[] noArgc = new Class[0];
    public static final Object[] noArgs = new Object[0];
    private XMLHistBuilder xhb;

    public XMLHistViewer(String str, String fileName) {
        super(str);
        this.getContentPane().add(new JLabel("Reading " + fileName + "..."));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    void load(String fileName) {
        try {
            this.xhb = new XMLHistBuilder(new BufferedReader(new FileReader(fileName)), fileName);
            final JASHist hist = this.xhb.getSoloPlot();
            if (hist == null) {
                throw new RuntimeException("No Histogram found");
            }
            final JPanel p = new JPanel(new BorderLayout());
            p.add("Center", hist);
            JButton export = new JButton("Save As...");
            export.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    hist.saveAs();
                }
            });
            p.add("South", export);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XMLHistViewer.this.setContentPane(p);
                    XMLHistViewer.this.pack();
                }
            });
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XMLHistViewer.this.dispose();
                    JOptionPane.showMessageDialog(null, t.getMessage(), "Error", 0);
                    System.exit(0);
                }
            });
        }
    }

    public static void main(String[] args) {
        Object reg;
        Method m;
        Class<?> c;
        XMLHistViewer xhv = new XMLHistViewer("XMLHistViewer", args[0]);
        xhv.pack();
        xhv.show();
        xhv.load(args[0]);
        try {
            c = Class.forName("jasext.hist.Register");
            m = c.getMethod("init", noArgc);
            reg = c.newInstance();
            m.invoke(reg, noArgs);
        }
        catch (Throwable t) {
            System.err.println("Unable to register functions/fitters");
            t.printStackTrace();
        }
        try {
            c = Class.forName("jas.export.Register");
            m = c.getMethod("init", noArgc);
            reg = c.newInstance();
            m.invoke(reg, noArgs);
        }
        catch (Throwable t) {
            System.err.println("Unable to register exporters");
        }
    }
}

