/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.test.MyCustomOverlay;
import java.util.Observable;
import java.util.Random;

public class TestCustomOverlay
extends Observable
implements ScatterPlotSource,
HasStyle,
Runnable {
    private double[] values = new double[100];
    private double[] times = new double[100];
    private int maxPoint = 0;
    private double xmin = 0.0;
    private double xmax = 0.0;
    private static final HistogramUpdate hdr = new HistogramUpdate(6, true);
    protected double[] x;
    protected double[] y;
    private Random random = new Random();

    public TestCustomOverlay() {
        hdr.setAxis(TestCustomOverlay.hdr.HORIZONTAL_AXIS);
        hdr.setAxis(TestCustomOverlay.hdr.VERTICAL_AXIS);
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        double previousValue = 0.0;
        double value = 0.0;
        try {
            while (true) {
                Thread.sleep(100L);
                if (!(Math.abs((value += Math.random() - 0.5) - previousValue) > 2.0)) continue;
                this.addPoint(value, (double)System.currentTimeMillis() / 1000.0);
                previousValue = value;
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    synchronized void addPoint(double value, double time) {
        if (this.maxPoint < this.values.length) {
            this.values[this.maxPoint] = value;
            this.times[this.maxPoint] = time;
            this.xmin = Math.min(this.xmin, value);
            this.xmax = Math.max(this.xmax, value);
            ++this.maxPoint;
        } else {
            this.xmin = this.xmax = this.values[1];
            for (int i = 1; i < this.maxPoint; ++i) {
                double v = this.values[i];
                this.xmin = Math.min(this.xmin, v);
                this.xmax = Math.max(this.xmax, v);
                this.values[i - 1] = v;
                this.times[i - 1] = this.times[i];
            }
            this.values[this.maxPoint - 1] = value;
            this.times[this.maxPoint - 1] = time;
        }
        this.setChanged();
        this.notifyObservers(hdr);
    }

    @Override
    public JASHistStyle getStyle() {
        JASHistScatterPlotStyle style = new JASHistScatterPlotStyle();
        style.setCustomOverlay(new MyCustomOverlay());
        return style;
    }

    @Override
    public ScatterEnumeration startEnumeration(double xMin, double xMax, double yMin, double yMax) {
        return new CustomEnumeration();
    }

    @Override
    public ScatterEnumeration startEnumeration() {
        return new CustomEnumeration();
    }

    @Override
    public double getXMin() {
        return this.times[0];
    }

    @Override
    public double getXMax() {
        return this.times[this.maxPoint - 1];
    }

    @Override
    public double getYMin() {
        return this.xmin;
    }

    @Override
    public double getYMax() {
        return this.xmax;
    }

    public void clearChanges() {
    }

    @Override
    public int getXAxisType() {
        return 3;
    }

    @Override
    public int getYAxisType() {
        return 1;
    }

    @Override
    public String getTitle() {
        return "Custom Overlay";
    }

    private class CustomEnumeration
    implements ScatterEnumeration {
        private int n = 0;

        private CustomEnumeration() {
        }

        @Override
        public boolean getNextPoint(double[] d) {
            if (this.n < TestCustomOverlay.this.maxPoint) {
                d[0] = TestCustomOverlay.this.times[this.n];
                d[1] = TestCustomOverlay.this.values[this.n];
                ++this.n;
                return true;
            }
            return false;
        }

        @Override
        public void resetEndPoint() {
        }

        @Override
        public void restart() {
            this.n = 0;
        }
    }
}

