/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.DataSource;
import jas.hist.HasDataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.hist.util.ObserverAdapter;
import java.util.Observable;

public class MemoryDataSource
extends ObserverAdapter
implements HasDataSource,
Rebinnable1DHistogramData,
HasStyle {
    private static final HistogramUpdate hdr = new HistogramUpdate(2, true);
    private static final int SECONDS = 60;
    private static MemoryThread t = new MemoryThread();

    public MemoryDataSource() {
        super(t);
    }

    @Override
    public DataSource getDataSource(String param) {
        return this;
    }

    @Override
    public double[][] rebin(int nbin, double min, double max, boolean wantErrors, boolean hurry) {
        double[] result = t.getSnapshot();
        double[][] r = new double[][]{result};
        return r;
    }

    @Override
    public double getMin() {
        return -60.0;
    }

    @Override
    public double getMax() {
        return 0.0;
    }

    @Override
    public int getBins() {
        return 60;
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public int getAxisType() {
        return 4;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    public Statistics getStatistics() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Java Memory Usage";
    }

    @Override
    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowErrorBars(false);
        style.setShowDataPoints(true);
        style.setShowLinesBetweenPoints(true);
        style.setShowHistogramBars(false);
        return style;
    }

    private static class MemoryThread
    extends Observable
    implements Runnable {
        private Thread thread;
        private int index = 0;
        private double[] bins = new double[60];

        MemoryThread() {
            for (int i = 0; i < 60; ++i) {
                this.bins[i] = Double.NaN;
            }
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runtime r = Runtime.getRuntime();
                while (true) {
                    MemoryThread memoryThread = this;
                    synchronized (memoryThread) {
                        this.bins[this.index++] = (double)(r.totalMemory() - r.freeMemory()) / 1000000.0;
                        if (this.index >= 60) {
                            this.index = 0;
                        }
                    }
                    this.setChanged();
                    this.notifyObservers(hdr);
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        synchronized double[] getSnapshot() {
            int i;
            double[] result = new double[60];
            int j = 0;
            for (i = this.index; i < 60; ++i) {
                result[j++] = this.bins[i];
            }
            for (i = 0; i < this.index; ++i) {
                result[j++] = this.bins[i];
            }
            return result;
        }
    }
}

