/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.FixedHeightPanel;
import jas.hist.JASHistAxis;
import jas.util.DateChooser;
import jas.util.JASTextField;
import jas.util.JTextFieldBinding;
import jas.util.PropertyBinding;
import jas.util.PropertyPage;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tablelayout.TableLayout;

final class JASHistPropAxis
extends PropertyPage
implements ActionListener {
    private JASTextField min;
    private JASTextField max;
    private JButton t1;
    private JButton t2;
    private int m_axisType;
    private JASTextField m_bins;
    private JASTextField m_binw;
    private JPanel m_binsPanel;
    private JPanel m_rangePanel;
    private JComboBox m_binwUnits;
    private JLabel m_type;
    private JCheckBox m_zero;
    private JCheckBox m_log;
    private JCheckBox m_showOverflow;
    private String[] types = new String[]{"", "Numeric", "String", "Date/Time"};
    private boolean init = false;

    public JASHistPropAxis() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createTopPanel());
        this.add(this.createRangePanel());
        this.add(this.createBinsPanel());
        this.add(Box.createVerticalGlue());
    }

    private JPanel createTopPanel() {
        JASTextField label = new JASTextField(20);
        this.m_log = new JCheckBox("Logarithmic");
        this.m_log.setMnemonic('L');
        this.m_type = new JLabel();
        this.addBinding(new PropertyBinding(label, "Label"));
        this.addBinding(new PropertyBinding(this.m_log, "logarithmic"));
        FixedHeightPanel p = new FixedHeightPanel(new TableLayout());
        p.add("0 0 rw", new JLabel("Label:"));
        p.add("0 1 rw", new JLabel("Type:"));
        p.add("1 0 2", label);
        p.add("1 1", this.m_type);
        p.add("2 1", this.m_log);
        return p;
    }

    private JPanel createRangePanel() {
        this.min = new JASTextField(15);
        this.max = new JASTextField(15);
        JCheckBox auto = new JCheckBox("Automatic");
        auto.setMnemonic('u');
        this.m_zero = new JCheckBox("Allow Suppressed Zero");
        this.m_zero.setMnemonic('Z');
        this.t1 = new JButton("...");
        this.t2 = new JButton("...");
        this.addBinding(new PropertyBinding(auto, "RangeAutomatic"));
        this.addBinding(new PropertyBinding(this.m_zero, "AllowSuppressedZero"));
        this.t1.addActionListener(this);
        this.t2.addActionListener(this);
        FixedHeightPanel p = new FixedHeightPanel(new TableLayout());
        p.setBorder(new TitledBorder("Range"));
        p.add("0 0 rw", new JLabel("Min:"));
        p.add("0 1 rw", new JLabel("Max:"));
        p.add("1 0 h", this.min);
        p.add("1 1 h", this.max);
        p.add("2 0 w", this.t1);
        p.add("2 1 w", this.t2);
        p.add("3 0 lW", auto);
        p.add("3 1 lW", this.m_zero);
        this.m_rangePanel = p;
        return p;
    }

    private JPanel createBinsPanel() {
        this.m_bins = new JASTextField(10);
        this.m_binw = new JASTextField(10);
        this.m_binwUnits = new JComboBox();
        this.m_binwUnits.addItem("Default Units");
        this.m_binwUnits.addItem("Seconds");
        this.m_binwUnits.addItem("Minutes");
        this.m_binwUnits.addItem("Hours");
        this.m_binwUnits.addItem("Days");
        this.m_binwUnits.addItem("Weeks");
        this.m_binwUnits.addItem("Years");
        this.m_showOverflow = new JCheckBox("Under/Overflow");
        FixedHeightPanel p = new FixedHeightPanel(new FlowLayout(0));
        p.setBorder(new TitledBorder("Binning"));
        p.add(new JLabel("Bins:"));
        p.add(this.m_bins);
        p.add(new JLabel("Bin Width:"));
        p.add(this.m_binw);
        p.add(this.m_binwUnits);
        p.add(this.m_showOverflow);
        this.m_binsPanel = p;
        return p;
    }

    @Override
    public void doDataExchange(boolean set, Object bean) {
        JASHistAxis axis = (JASHistAxis)bean;
        this.m_axisType = axis.getAxisType();
        if (!this.init) {
            this.init = true;
            if (this.m_axisType != 2) {
                this.addBinding(new PropertyBinding(new MinMaxFieldBinding(this.min), "MinObject"));
                this.addBinding(new PropertyBinding(new MinMaxFieldBinding(this.max), "MaxObject"));
                this.addBinding(new PropertyBinding(this.m_bins, "Bins", axis.isBinned() ? (byte)7 : 0));
                this.addBinding(new PropertyBinding(new BinWidthFieldBinding(this.m_binw), "BinWidth"));
                this.addBinding(new PropertyBinding(this.m_showOverflow, "ShowOverflows"));
            }
        }
        if (!set) {
            boolean enable = axis.isBinned();
            this.m_binsPanel.setEnabled(enable);
            enable = this.m_axisType != 2;
            this.m_rangePanel.setEnabled(enable);
            this.m_log.setEnabled(enable);
            this.m_zero.setEnabled(enable &= axis.getRangeAutomatic());
            enable = this.m_axisType == 3;
            this.t1.setEnabled(enable);
            this.t2.setEnabled(enable);
            this.m_type.setText(this.types[this.m_axisType]);
        }
        super.doDataExchange(set, bean);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Date t;
        DateChooser dlg;
        Container w = this;
        while (!(w instanceof Frame)) {
            w = w.getParent();
        }
        if (evt.getSource() == this.t1) {
            Date t2 = new Date(this.min.getText());
            DateChooser dlg2 = new DateChooser((Frame)w, t2);
            if (dlg2.doModal()) {
                this.min.setText(dlg2.getDate().toString());
            }
        } else if (evt.getSource() == this.t2 && (dlg = new DateChooser((Frame)w, t = new Date(this.max.getText()))).doModal()) {
            this.max.setText(dlg.getDate().toString());
        }
    }

    private final class BinWidthFieldBinding
    extends JTextFieldBinding
    implements ActionListener {
        private boolean conversionIndexIsDefault;
        private int conversionIndex;
        private double[] conversion;

        BinWidthFieldBinding(JASTextField field) {
            super(field, (byte)1);
            this.conversionIndexIsDefault = true;
            this.conversion = new double[]{1.0, 1.0, 60.0, 3600.0, 86400.0, 604800.0, 3.1536E7};
            JASHistPropAxis.this.m_binwUnits.addActionListener(this);
        }

        @Override
        protected String setValue(Object value) {
            if (JASHistPropAxis.this.m_axisType == 3) {
                double d = (Double)value;
                if (this.conversionIndexIsDefault) {
                    int i = 1;
                    while (++i != this.conversion.length && !(d / this.conversion[i] < 1.0)) {
                    }
                    this.conversionIndex = i - 1;
                }
                JASHistPropAxis.this.m_binwUnits.setEnabled(true);
                JASHistPropAxis.this.m_binwUnits.setSelectedIndex(this.conversionIndex);
                return String.valueOf(d / this.conversion[this.conversionIndex]);
            }
            this.conversionIndex = 0;
            JASHistPropAxis.this.m_binwUnits.setEnabled(false);
            JASHistPropAxis.this.m_binwUnits.setSelectedIndex(this.conversionIndex);
            return value.toString();
        }

        @Override
        protected Object getValue(String s, Class type) {
            double d = Double.valueOf(s);
            return new Double(d *= this.conversion[this.conversionIndex]);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int i = JASHistPropAxis.this.m_binwUnits.getSelectedIndex();
            if (i == this.conversionIndex) {
                return;
            }
            String s = JASHistPropAxis.this.m_binw.getText();
            double d = Double.valueOf(s);
            d *= this.conversion[this.conversionIndex];
            this.conversionIndex = i;
            JASHistPropAxis.this.m_binw.setText(String.valueOf(d /= this.conversion[this.conversionIndex]));
            this.conversionIndexIsDefault = false;
        }
    }

    private final class MinMaxFieldBinding
    extends JTextFieldBinding {
        MinMaxFieldBinding(JASTextField field) {
            super(field);
        }

        @Override
        protected Object getValue(String s, Class type) {
            if (JASHistPropAxis.this.m_axisType == 3) {
                return new Date(s);
            }
            return new Double(s);
        }
    }
}

