/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DateTransformationConverter;
import jas.hist.FunctionValueUndefined;
import jas.hist.JASHist1DFunctionData;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.OverlayWithHandles;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.PlotGraphics;
import jas.plot.Transformation;
import java.awt.BasicStroke;

class JASHistFunctionOverlay
extends OverlayWithHandles
implements MutableLegendEntry {
    private static final float[][] lineStyles = new float[][]{null, {1.0f, 5.0f}, {4.0f, 6.0f}, {6.0f, 4.0f, 2.0f, 4.0f}};
    private JASHist1DFunctionStyle style;
    private JASHist1DFunctionData source;
    private double xmin;
    private double xmax;

    JASHistFunctionOverlay(JASHist1DFunctionData source, JASHist1DFunctionStyle style) {
        super(source.getDataSource());
        this.source = source;
        this.style = style;
    }

    void setXRange(double xmin, double xmax) {
        this.xmin = xmin;
        this.xmax = xmax;
    }

    @Override
    public void paint(PlotGraphics g, boolean isPrinting) {
        CoordinateTransformation xp = this.container.getXTransformation();
        CoordinateTransformation yp = this.container.getYTransformation(this.source.getYAxis());
        Basic1DFunction f = (Basic1DFunction)this.source.getDataSource();
        Transformation xT = null;
        Transformation yT = null;
        if (xp instanceof DoubleCoordinateTransformation) {
            xT = (Transformation)((Object)xp);
        }
        if (xp instanceof DateCoordinateTransformation) {
            xT = new DateTransformationConverter((DateCoordinateTransformation)xp);
        }
        if (yp instanceof DoubleCoordinateTransformation) {
            yT = (Transformation)((Object)yp);
        }
        if (yp instanceof DateCoordinateTransformation) {
            yT = new DateTransformationConverter((DateCoordinateTransformation)yp);
        }
        if (xT != null && yT != null) {
            g.setTransformation(xT, yT);
            double xi = (this.xmax - this.xmin) / (xT.convert(this.xmax) - xT.convert(this.xmin));
            double yold = Double.NEGATIVE_INFINITY;
            g.setColor(this.style.getLineColor());
            BasicStroke s = new BasicStroke(this.style.getLineWidth(), 2, 1, 10.0f, lineStyles[this.style.getLineStyle()], 0.0f);
            g.setStroke(s);
            int lpbn = 0;
            for (double x = this.xmin; x < this.xmax; x += xi) {
                ++lpbn;
            }
            double[] lpbx = new double[lpbn];
            double[] lpby = new double[lpbn];
            int count = 0;
            for (double x = this.xmin; x < this.xmax; x += xi) {
                try {
                    double y;
                    lpbx[count] = x;
                    lpby[count] = y = f.valueAt(x);
                    yold = y;
                }
                catch (FunctionValueUndefined xx) {
                    lpby[count] = yold;
                }
                ++count;
            }
            g.drawPolyLine(lpbx, lpby, lpbn);
            g.setStroke(null);
            super.paint(g);
        }
    }

    @Override
    public boolean titleIsChanged() {
        return this.source.isLegendChanged();
    }

    @Override
    public void setTitle(String newTitle) {
        this.source.setLegendText(newTitle);
    }

    @Override
    public String getTitle() {
        return this.source.getLegendText();
    }

    @Override
    public void paintIcon(PlotGraphics g, int width, int height) {
        g.setColor(this.style.getLineColor());
        float flw = this.style.getLineWidth() * 3.0f;
        if (flw > (float)(width / 2)) {
            flw = width > 2 ? (float)(width / 2 - 1) : 1.0f;
        }
        BasicStroke s = new BasicStroke(flw, 2, 1, 10.0f, lineStyles[this.style.getLineStyle()], 0.0f);
        g.setStroke(s);
        g.setStroke(s);
        g.drawLine(1.0, height / 2, width - 2, height / 2);
        g.setStroke(null);
    }
}

