/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistFunctionOverlay;
import jas.hist.JASHistStyle;
import jas.hist.SupportsFunctions;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Observable;

class JASHist1DFunctionData
extends JASHistData
implements Serializable {
    private double lowerBound = Double.NaN;
    private double upperBound = Double.NaN;
    private Basic1DFunction dataSource;
    private double xLow;
    private double xHigh;
    private double xIncrement;
    private transient Double hole;
    private JASHist1DFunctionStyle style;
    static final long serialVersionUID = -3529869583896718619L;

    JASHist1DFunctionData(DataManager parent, Basic1DFunction ds) {
        super(parent);
        this.dataSource = ds;
        this.style = new JASHist1DFunctionStyle();
        this.style.addObserver(this);
    }

    @Override
    public void setStyle(JASHistStyle style) {
        if (!(style instanceof JASHist1DFunctionStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist1DFunctionStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist1DFunctionStyle)style;
        style.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.dataSource) {
            ((SupportsFunctions)((Object)this.parent)).update(this);
        } else if (o == this.style) {
            ((SupportsFunctions)((Object)this.parent)).update(this);
        }
    }

    @Override
    public void axisChanged() {
        ((SupportsFunctions)((Object)this.parent)).update(this);
    }

    @Override
    public void setXBounds(double xmin, double xmax) {
        this.lowerBound = xmin;
        this.upperBound = xmax;
    }

    void setXRange(double xmin, double xmax) {
        if (!Double.isNaN(this.lowerBound)) {
            double d = xmin = xmin < this.lowerBound ? this.lowerBound : xmin;
        }
        if (!Double.isNaN(this.upperBound)) {
            double d = xmax = xmax > this.upperBound ? this.upperBound : xmax;
        }
        if (xmin > xmax) {
            xmin = xmax;
        }
        if (this.overlay instanceof JASHistFunctionOverlay) {
            ((JASHistFunctionOverlay)this.overlay).setXRange(xmin, xmax);
        }
    }

    @Override
    public String getTitle() {
        return this.dataSource.getTitle();
    }

    @Override
    Overlay createOverlay() {
        return new JASHistFunctionOverlay(this, this.style);
    }

    @Override
    public JASHistStyle getStyle() {
        return this.style;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    void normalizationChanged(boolean now) {
    }

    @Override
    public void writeAsXML(XMLPrintWriter pw, boolean snapshot) {
        pw.setAttribute("axis", "y" + this.getYAxis());
        pw.setAttribute("type", this.dataSource.getTitle());
        pw.openTag("function1d");
        String[] pNames = this.dataSource.getParameterNames();
        double[] pValue = this.dataSource.getParameterValues();
        for (int i = 0; i < pNames.length; ++i) {
            pw.setAttribute("name", pNames[i]);
            pw.setAttribute("value", pValue[i]);
            pw.printTag("functionParam");
        }
        pw.setAttribute("lineColor", ColorConverter.colorToString(this.style.getLineColor()));
        pw.printTag("functionStyle1d");
        pw.closeTag();
    }

    Basic1DFunction getFunction() {
        return this.dataSource;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.parent);
        out.writeInt(this.yAxisIndex);
        out.writeBoolean(this.isVisible);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.isVisible = false;
        this.parent = (DataManager)in.readObject();
        this.yAxisIndex = in.readInt();
        this.style.addObserver(this);
        if (in.readBoolean()) {
            if (this.dataSource instanceof Observable) {
                this.dataSource.addObserver(this);
            }
            this.show(true);
        }
    }

    public void delete() {
        ((SupportsFunctions)((Object)this.parent)).removeFunction(this);
    }

    void destroy() {
        this.dataSource.destroy();
        this.dataSource.deleteObserver(this);
        this.style.deleteObserver(this);
        super.deleteNormalizationObserver();
    }
}

