/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util.tree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.tree.TreeNode;
import org.jgap.util.tree.TreeBranchRenderer;
import org.jgap.util.tree.TreeNodeRenderer;

public class TreeVisualizer {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private int side = 512;
    private double circleDiminishFactor = 0.875;
    private double branchStartWidth = 16.0;
    private double branchDiminshFactor = 0.6666;
    private TreeBranchRenderer tbr = null;
    private TreeNodeRenderer tnr = null;
    private Color bkgndColor = Color.white;
    private Color arenaColor = Color.black;
    private Color branchColor = Color.white;
    private Color nodeColor = Color.red;
    private boolean renderNodes = true;
    private int ignorePastLevel = -1;

    public BufferedImage renderTree(TreeNode tn) {
        BufferedImage bufferedImage = new BufferedImage(this.side, this.side, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2d.setColor(this.bkgndColor);
        g2d.fillRect(0, 0, this.side, this.side);
        g2d.setColor(this.arenaColor);
        g2d.fillOval(0, 0, this.side, this.side);
        g2d.setColor(this.branchColor);
        this.drawBranches(g2d, tn, 0, 0.0, Math.PI * 2);
        if (this.renderNodes) {
            g2d.setColor(this.nodeColor);
            this.drawNodes(g2d, tn, 0, 0.0, Math.PI * 2);
        }
        g2d.dispose();
        return bufferedImage;
    }

    public void writeImageFile(RenderedImage ri, File f) {
        try {
            ImageIO.write(ri, "png", f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Point drawBranches(Graphics2D g, TreeNode tn, int level, double start, double finish) {
        double span = finish - start;
        double middle = start + span / 2.0;
        Point middlePoint = this.radToCart(this.getR(level), middle, this.side / 2, this.side / 2);
        Stroke strokeSize = this.getStroke(level);
        if (!tn.isLeaf()) {
            if (this.ignorePastLevel >= 0 && this.ignorePastLevel < level + 1) {
                return middlePoint;
            }
            double subSection = span / (double)tn.getChildCount();
            double s1 = start;
            double s2 = start + subSection;
            for (int i = 0; i < tn.getChildCount(); ++i) {
                Color nc;
                TreeNode tn2 = tn.getChildAt(i);
                Point connectPoint = this.drawBranches(g, tn2, level + 1, s1, s2);
                g.setStroke(strokeSize);
                if (this.tbr != null && (nc = this.tbr.getBranchColor(tn, level)) != null) {
                    g.setColor(nc);
                }
                g.drawLine((int)middlePoint.getX(), (int)middlePoint.getY(), (int)connectPoint.getX(), (int)connectPoint.getY());
                s1 += subSection;
                s2 += subSection;
            }
        }
        return middlePoint;
    }

    private void drawNodes(Graphics2D g, TreeNode tn, int level, double start, double finish) {
        double span = finish - start;
        double middle = start + span / 2.0;
        Point middlePoint = this.radToCart(this.getR(level), middle, this.side / 2, this.side / 2);
        double x = middlePoint.getX();
        double y = middlePoint.getY();
        g.setStroke(new BasicStroke(0.0f));
        double r = this.branchStartWidth * Math.pow(this.branchDiminshFactor, level);
        if ((int)(2.0 * r) > 0) {
            Color nc;
            if (this.tnr != null && (nc = this.tnr.getNodeColor(tn, level)) != null) {
                g.setColor(nc);
            }
            g.fillOval((int)(x - r), (int)(y - r), (int)(2.0 * r), (int)(2.0 * r));
        }
        if (!tn.isLeaf()) {
            if (this.ignorePastLevel >= 0 && this.ignorePastLevel < level + 1) {
                return;
            }
            double subSection = span / (double)tn.getChildCount();
            double s1 = start;
            double s2 = start + subSection;
            for (int i = 0; i < tn.getChildCount(); ++i) {
                TreeNode tn2 = tn.getChildAt(i);
                this.drawNodes(g, tn2, level + 1, s1, s2);
                s1 += subSection;
                s2 += subSection;
            }
        }
    }

    private Stroke getStroke(int level) {
        return new BasicStroke((float)(this.branchStartWidth * Math.pow(this.branchDiminshFactor, level)), 1, 0);
    }

    private Point radToCart(double r, double theta, int x, int y) {
        int nx = (int)(r * Math.cos(theta += 1.5707963267948966)) + x;
        int ny = (int)(r * Math.sin(theta)) + y;
        return new Point(nx, ny);
    }

    private double getR(int level) {
        double r = (double)(this.side / 2) - (double)(this.side / 2) * Math.pow(this.circleDiminishFactor, level);
        return r;
    }

    public void setSide(int s) {
        this.side = s;
    }

    public int getSide() {
        return this.side;
    }

    public void setCircleDiminishFactor(double c) {
        this.circleDiminishFactor = c;
    }

    public double getCircleDiminishFactor() {
        return this.circleDiminishFactor;
    }

    public void setBranchStartWidth(double b) {
        this.branchStartWidth = b;
    }

    public double getBranchStartWidth() {
        return this.branchStartWidth;
    }

    public void setBranchDiminishFactor(double s) {
        this.branchDiminshFactor = s;
    }

    public double getBranchDiminshFactor() {
        return this.branchDiminshFactor;
    }

    public void setBkgndColor(Color c) {
        this.bkgndColor = c;
    }

    public Color getBkgndColor() {
        return this.bkgndColor;
    }

    public void setArenaColor(Color c) {
        this.arenaColor = c;
    }

    public Color getArenaColor() {
        return this.arenaColor;
    }

    public void setBranchColor(Color c) {
        this.branchColor = c;
    }

    public Color getBranchColor() {
        return this.branchColor;
    }

    public void setNodeColor(Color c) {
        this.nodeColor = c;
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public void setTreeBranchRenderer(TreeBranchRenderer ntbr) {
        this.tbr = ntbr;
    }

    public TreeBranchRenderer getTreeBranchRenderer() {
        return this.tbr;
    }

    public void setTreeNodeRenderer(TreeNodeRenderer ntnr) {
        this.tnr = ntnr;
    }

    public TreeNodeRenderer getTreeNodeRenderer() {
        return this.tnr;
    }

    public void setRenderNodes(boolean r) {
        this.renderNodes = r;
    }

    public boolean getRenderNodes() {
        return this.renderNodes;
    }

    public void setIgnorePastLevel(int i) {
        this.ignorePastLevel = i;
    }

    public int getIgnorePastLevel() {
        return this.ignorePastLevel;
    }
}

