/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jgap.util.NumberKit;
import org.jgap.util.StringKit;
import org.jgap.util.SystemKit;

public final class NetworkKit {
    private static final String CVS_REVISION = "$Revision: 1.5 $";

    private NetworkKit() {
    }

    public static String getLocalIPAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMACAddress() {
        String macAddress = null;
        Process p = null;
        BufferedReader in = null;
        try {
            String osname = System.getProperty("os.name");
            if (osname.startsWith("Windows")) {
                p = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
            } else if (osname.startsWith("Solaris") || osname.startsWith("SunOS")) {
                String hostName = SystemKit.getFirstLineOfCommand(new String[]{"uname", "-n"});
                if (hostName != null) {
                    p = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", hostName}, null);
                }
            } else if (new File("/usr/sbin/lanscan").exists()) {
                p = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
            } else if (new File("/sbin/ifconfig").exists()) {
                p = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
            }
            if (p != null) {
                in = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
                String l = null;
                while ((l = in.readLine()) != null && ((macAddress = StringKit.parse(l)) == null || NumberKit.parseShort(macAddress) == 255)) {
                }
            }
        }
        catch (SecurityException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            if (p != null) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
                try {
                    p.getErrorStream().close();
                }
                catch (IOException ex) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException ex) {}
                p.destroy();
            }
        }
        return macAddress;
    }

    public static void main(String[] args) {
        System.out.println(NetworkKit.getMACAddress());
    }
}

