/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.symbolic;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Sigmoid
extends MathCommand
implements ICloneable {
    public Sigmoid(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 1, a_returnType);
    }

    @Override
    public String toString() {
        return "sigmoid &1";
    }

    @Override
    public String getName() {
        return "Sigmoid";
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        float f = c.execute_float(n, 0, args);
        return 1.0f / (1.0f + (float)Math.exp(-f));
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double d = c.execute_double(n, 0, args);
        return 1.0 / (1.0 + Math.exp(-d));
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        return ((Compatible)c.execute_object(n, 0, args)).execute_sigmoid();
    }

    @Override
    public Object clone() {
        try {
            Sigmoid result = new Sigmoid(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_sigmoid();
    }
}

