/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.symbolic;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ModuloD
extends MathCommand
implements ICloneable {
    public ModuloD(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType);
    }

    @Override
    public String toString() {
        return "&1 mod &2";
    }

    @Override
    public String getName() {
        return "ModuloD";
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double v1 = c.execute_double(n, 0, args);
        double v2 = c.execute_double(n, 1, args);
        if (Math.abs(v2) < 1.0E-7) {
            return 0.0;
        }
        Integer i1 = (int)v1;
        Integer i2 = (int)v2;
        if (i2 == 0) {
            return 0.0;
        }
        return i1 % i2;
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        try {
            return ((Compatible)c.execute_object(n, 0, args)).execute_mod_d(c.execute_object(n, 1, args));
        }
        catch (ArithmeticException aex) {
            throw new IllegalStateException("mod with illegal arguments");
        }
    }

    @Override
    public Object clone() {
        try {
            ModuloD result = new ModuloD(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_mod_d(Object var1);
    }
}

