/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.symbolic;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ForLoopD
extends CommandGene
implements ICloneable {
    private static String INTERNAL_COUNTER_STORAGE = "FORLOOPSTORAGE_INT";
    private Class m_typeVar;
    private int m_startIndex;
    private int m_endIndex;
    private int m_increment;
    private int m_maxLoop;
    private String m_memory_name_int;
    private String m_varName;

    public ForLoopD(GPConfiguration a_conf, Class a_typeVar, int a_maxLoop) throws InvalidConfigurationException {
        this(a_conf, a_typeVar, 0, a_maxLoop);
    }

    public ForLoopD(GPConfiguration a_conf, Class a_typeVar, int a_startIndex, int a_maxLoop) throws InvalidConfigurationException {
        this(a_conf, a_typeVar, a_startIndex, a_maxLoop, "i");
    }

    public ForLoopD(GPConfiguration a_conf, Class a_typeVar, int a_startIndex, int a_maxLoop, String a_varName) throws InvalidConfigurationException {
        super(a_conf, 2, CommandGene.DoubleClass);
        this.m_typeVar = a_typeVar;
        this.m_maxLoop = a_maxLoop;
        this.m_startIndex = a_startIndex;
        this.m_endIndex = -1;
        this.m_increment = 1;
        this.m_varName = a_varName;
        this.init();
    }

    public ForLoopD(GPConfiguration a_conf, Class a_typeVar, int a_startIndex, int a_endIndex, int a_increment, String a_varName) throws InvalidConfigurationException {
        this(a_conf, a_typeVar, a_startIndex, a_endIndex, a_increment, a_varName, 0, 0);
    }

    public ForLoopD(GPConfiguration a_conf, Class a_typeVar, int a_startIndex, int a_endIndex, int a_increment, String a_varName, int a_subReturnType, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.DoubleClass, a_subReturnType, a_subChildType);
        this.m_typeVar = a_typeVar;
        this.m_increment = a_increment;
        this.m_startIndex = a_startIndex;
        this.m_endIndex = a_endIndex;
        this.m_varName = a_varName;
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.m_memory_name_int = INTERNAL_COUNTER_STORAGE;
        this.m_memory_name_int = this.m_memory_name_int + this.m_varName;
        this.m_memory_name_int = this.m_memory_name_int + this.getGPConfiguration().getRandomGenerator().nextDouble();
    }

    @Override
    public String toString() {
        if (this.m_endIndex == -1) {
            return "for(int i=" + this.m_startIndex + ";i<&1;i++) { &2 }";
        }
        String incrString = this.m_increment == 1 ? this.m_varName + "++" : this.m_varName + "=" + this.m_varName + "+1";
        return "for(int " + this.m_varName + "=" + this.m_startIndex + ";" + this.m_varName + "<" + this.m_endIndex + ";" + incrString + ") { &1 }";
    }

    @Override
    public String getName() {
        return "ForLoopD";
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        StringBuffer value = new StringBuffer();
        value = value.append("for(int " + this.m_varName + "=" + this.m_startIndex + ";" + this.m_varName + "<" + this.m_endIndex + ";" + this.m_varName + "++) {");
        for (int i = 0; i < this.size(); ++i) {
            value = value.append((StringBuffer)c.execute_object(n, i, args));
        }
        value = value.append("}");
        return value;
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        if (this.m_endIndex == -1) {
            int x;
            if (this.m_typeVar == CommandGene.IntegerClass) {
                x = c.execute_int(n, 0, args);
            } else if (this.m_typeVar == CommandGene.LongClass) {
                x = (int)c.execute_long(n, 0, args);
            } else if (this.m_typeVar == CommandGene.DoubleClass) {
                x = (int)Math.round(c.execute_double(n, 0, args));
            } else if (this.m_typeVar == CommandGene.FloatClass) {
                x = Math.round(c.execute_float(n, 0, args));
            } else {
                throw new RuntimeException("Type " + this.m_typeVar + " not supported by ForLoopD");
            }
            if (x > this.m_maxLoop) {
                x = this.m_maxLoop;
            }
            for (int i = this.m_startIndex; i < x; ++i) {
                c.execute_void(n, 1, args);
            }
        } else {
            for (int i = this.m_startIndex; i < this.m_endIndex; i += this.m_increment) {
                this.getGPConfiguration().storeInMemory(INTERNAL_COUNTER_STORAGE, new Integer(i));
                c.execute_void(n, 0, args);
            }
        }
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        if (this.m_endIndex == -1) {
            if (this.m_typeVar != CommandGene.DoubleClass) {
                throw new RuntimeException("Type " + this.m_typeVar + " not supported by ForLoopD");
            }
            int x = (int)Math.round(c.execute_double(n, 0, args));
            if (x > this.m_maxLoop) {
                x = this.m_maxLoop;
            }
            double res = 0.0;
            for (int i = this.m_startIndex; i < x; ++i) {
                res += c.execute_double(n, 1, args);
            }
            return res;
        }
        double res = 0.0;
        for (int i = this.m_startIndex; i < this.m_endIndex; i += this.m_increment) {
            this.getGPConfiguration().storeInMemory(INTERNAL_COUNTER_STORAGE, new Integer(i));
            res += c.execute_double(n, 0, args);
        }
        return res;
    }

    @Override
    public boolean isValid(ProgramChromosome a_program) {
        return true;
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (this.m_endIndex == -1) {
            if (a_chromNum == 0) {
                return this.m_typeVar;
            }
            return CommandGene.DoubleClass;
        }
        return CommandGene.DoubleClass;
    }

    public String getVarName() {
        return this.m_varName;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ForLoopD other = (ForLoopD)a_other;
        return new CompareToBuilder().append((Object)this.m_typeVar, (Object)other.m_typeVar).append(this.m_maxLoop, other.m_maxLoop).append(this.m_startIndex, other.m_startIndex).append(this.m_endIndex, other.m_endIndex).append(this.m_increment, other.m_increment).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            ForLoopD other = (ForLoopD)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_typeVar, (Object)other.m_typeVar).append(this.m_maxLoop, other.m_maxLoop).append(this.m_startIndex, other.m_startIndex).append(this.m_endIndex, other.m_endIndex).append(this.m_increment, other.m_increment).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public String getCounterMemoryName() {
        return this.m_memory_name_int;
    }

    @Override
    public Object clone() {
        try {
            ForLoopD result = this.getArity(null) == 1 ? new ForLoopD(this.getGPConfiguration(), this.m_typeVar, this.m_startIndex, this.m_endIndex, this.m_increment, this.m_varName, this.getSubReturnType(), this.getSubChildType(0)) : new ForLoopD(this.getGPConfiguration(), this.m_typeVar, this.m_startIndex, this.m_maxLoop, this.m_varName);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

