/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl.salesman;

import java.io.Serializable;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.DefaultFitnessEvaluator;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.event.EventManager;
import org.jgap.impl.BestChromosomesSelector;
import org.jgap.impl.ChromosomePool;
import org.jgap.impl.GreedyCrossover;
import org.jgap.impl.StockRandomGenerator;
import org.jgap.impl.SwappingMutationOperator;
import org.jgap.impl.salesman.SalesmanFitnessFunction;

public abstract class Salesman
implements Serializable {
    private static final String CVS_REVISION = "$Revision: 1.22 $";
    private Configuration m_config;
    private int m_maxEvolution = 128;
    private int m_populationSize = 512;
    private int m_startOffset = 1;

    public abstract double distance(Gene var1, Gene var2);

    public abstract IChromosome createSampleChromosome(Object var1);

    public FitnessFunction createFitnessFunction(Object a_initial_data) {
        return new SalesmanFitnessFunction(this);
    }

    public Configuration createConfiguration(Object a_initial_data) throws InvalidConfigurationException {
        Configuration config = new Configuration();
        BestChromosomesSelector bestChromsSelector = new BestChromosomesSelector(config, 1.0);
        bestChromsSelector.setDoubletteChromosomesAllowed(false);
        config.addNaturalSelector(bestChromsSelector, true);
        config.setRandomGenerator(new StockRandomGenerator());
        config.setMinimumPopSizePercent(0);
        config.setEventManager(new EventManager());
        config.setFitnessEvaluator(new DefaultFitnessEvaluator());
        config.setChromosomePool(new ChromosomePool());
        config.addGeneticOperator(new GreedyCrossover(config));
        config.addGeneticOperator(new SwappingMutationOperator(config, 20));
        return config;
    }

    public int getMaxEvolution() {
        return this.m_maxEvolution;
    }

    public void setMaxEvolution(int a_maxEvolution) {
        this.m_maxEvolution = a_maxEvolution;
    }

    public int getPopulationSize() {
        return this.m_populationSize;
    }

    public void setPopulationSize(int a_populationSize) {
        this.m_populationSize = a_populationSize;
    }

    public IChromosome findOptimalPath(Object a_initial_data) throws Exception {
        this.m_config = this.createConfiguration(a_initial_data);
        FitnessFunction myFunc = this.createFitnessFunction(a_initial_data);
        this.m_config.setFitnessFunction(myFunc);
        IChromosome sampleChromosome = this.createSampleChromosome(a_initial_data);
        this.m_config.setSampleChromosome(sampleChromosome);
        this.m_config.setPopulationSize(this.getPopulationSize());
        IChromosome[] chromosomes = new IChromosome[this.m_config.getPopulationSize()];
        Gene[] samplegenes = sampleChromosome.getGenes();
        for (int i = 0; i < chromosomes.length; ++i) {
            Gene[] genes = new Gene[samplegenes.length];
            for (int k = 0; k < genes.length; ++k) {
                genes[k] = samplegenes[k].newGene();
                genes[k].setAllele(samplegenes[k].getAllele());
            }
            chromosomes[i] = new Chromosome(this.m_config, genes);
        }
        Genotype population = new Genotype(this.m_config, new Population(this.m_config, chromosomes));
        IChromosome best = null;
        for (int i = 0; i < this.getMaxEvolution(); ++i) {
            population.evolve();
            best = population.getFittestChromosome();
        }
        return best;
    }

    public void setStartOffset(int a_offset) {
        this.m_startOffset = a_offset;
    }

    public int getStartOffset() {
        return this.m_startOffset;
    }

    public Configuration getConfiguration() {
        return this.m_config;
    }
}

