/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.List;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.IChromosome;
import org.jgap.IUniversalRateCalculator;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.impl.MutationOperator;

public class SwappingMutationOperator
extends MutationOperator {
    private static final String CVS_REVISION = "$Revision: 1.21 $";
    private int m_startOffset = 1;

    public SwappingMutationOperator() throws InvalidConfigurationException {
    }

    public SwappingMutationOperator(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
    }

    public SwappingMutationOperator(Configuration a_config, IUniversalRateCalculator a_mutationRateCalculator) throws InvalidConfigurationException {
        super(a_config, a_mutationRateCalculator);
    }

    public SwappingMutationOperator(Configuration a_config, int a_desiredMutationRate) throws InvalidConfigurationException {
        super(a_config, a_desiredMutationRate);
    }

    @Override
    public void operate(Population a_population, List a_candidateChromosomes) {
        IUniversalRateCalculator m_mutationRateCalc = this.getMutationRateCalc();
        if (this.getMutationRate() == 0 && m_mutationRateCalc == null) {
            return;
        }
        int currentRate = m_mutationRateCalc != null ? m_mutationRateCalc.calculateCurrentRate() : this.getMutationRate();
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        int size = a_population.size();
        for (int i = 0; i < size; ++i) {
            IChromosome x = a_population.getChromosome(i);
            IChromosome xm = this.operate(x, currentRate, generator);
            if (xm == null) continue;
            a_candidateChromosomes.add(xm);
        }
    }

    protected IChromosome operate(IChromosome a_chrom, int a_rate, RandomGenerator a_generator) {
        IChromosome chromosome = null;
        for (int j = this.m_startOffset; j < a_chrom.size(); ++j) {
            if (a_generator.nextInt(a_rate) != 0) continue;
            if (chromosome == null) {
                chromosome = (IChromosome)a_chrom.clone();
                if (this.m_monitorActive) {
                    chromosome.setUniqueIDTemplate(a_chrom.getUniqueID(), 1);
                }
            }
            Gene[] genes = chromosome.getGenes();
            Gene[] mutated = this.operate(a_generator, j, genes);
            try {
                chromosome.setGenes(mutated);
                continue;
            }
            catch (InvalidConfigurationException cex) {
                throw new Error("Gene type not allowed by constraint checker", cex);
            }
        }
        return chromosome;
    }

    protected Gene[] operate(RandomGenerator a_generator, int a_target_gene, Gene[] a_genes) {
        int other = this.m_startOffset + a_generator.nextInt(a_genes.length - this.m_startOffset);
        Gene t = a_genes[a_target_gene];
        a_genes[a_target_gene] = a_genes[other];
        a_genes[other] = t;
        if (this.m_monitorActive) {
            a_genes[a_target_gene].setUniqueIDTemplate(a_genes[other].getUniqueID(), 1);
            a_genes[other].setUniqueIDTemplate(a_genes[a_target_gene].getUniqueID(), 1);
        }
        return a_genes;
    }

    public void setStartOffset(int a_offset) {
        this.m_startOffset = a_offset;
    }

    public int getStartOffset() {
        return this.m_startOffset;
    }
}

