/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IBusinessKey;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class StringGene
extends BaseGene
implements IPersistentRepresentation,
IBusinessKey {
    public static final String ALPHABET_CHARACTERS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHABET_CHARACTERS_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHABET_CHARACTERS_DIGITS = "0123456789";
    public static final String ALPHABET_CHARACTERS_SPECIAL = "+.*/\\,;@";
    private static final String CVS_REVISION = "$Revision: 1.58 $";
    private int m_minLength;
    private int m_maxLength;
    private String m_alphabet;
    private String m_value;

    public StringGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public StringGene(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, 0, 0);
    }

    public StringGene(Configuration a_config, int a_minLength, int a_maxLength) throws InvalidConfigurationException {
        this(a_config, a_minLength, a_maxLength, null);
    }

    public StringGene(Configuration a_config, int a_minLength, int a_maxLength, String a_alphabet) throws InvalidConfigurationException {
        super(a_config);
        if (a_minLength < 0) {
            throw new IllegalArgumentException("minimum length must be greater than zero!");
        }
        if (a_maxLength < a_minLength) {
            throw new IllegalArgumentException("minimum length must be smaller than or equal to maximum length!");
        }
        this.m_minLength = a_minLength;
        this.m_maxLength = a_maxLength;
        this.setAlphabet(a_alphabet);
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        if (this.m_alphabet == null || this.m_alphabet.length() < 1) {
            throw new IllegalStateException("The valid alphabet is empty!");
        }
        if (this.m_maxLength < this.m_minLength || this.m_maxLength < 1) {
            throw new IllegalStateException("Illegal valid maximum and/or minimum length of alphabet!");
        }
        int length = this.m_maxLength - this.m_minLength + 1;
        int i = a_numberGenerator.nextInt() % length;
        if (i < 0) {
            i = -i;
        }
        length = this.m_minLength + i;
        String newAllele = "";
        int alphabetLength = this.m_alphabet.length();
        for (int j = 0; j < length; ++j) {
            int index = a_numberGenerator.nextInt(alphabetLength);
            char value = this.m_alphabet.charAt(index);
            newAllele = newAllele + value;
        }
        this.setAllele(newAllele);
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 4) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation '" + a_representation + "'" + " is not recognized: it does not contain four tokens.");
            }
            String valueRepresentation = this.decode(tokenizer.nextToken());
            String minLengthRepresentation = tokenizer.nextToken();
            String maxLengthRepresentation = tokenizer.nextToken();
            String alphabetRepresentation = this.decode(tokenizer.nextToken());
            try {
                this.m_minLength = Integer.parseInt(minLengthRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_maxLength = Integer.parseInt(maxLengthRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
            String tempValue = valueRepresentation.equals("null") ? null : (valueRepresentation.equals("\"\"") ? "" : valueRepresentation);
            if (tempValue != null) {
                if (this.m_minLength > tempValue.length()) {
                    throw new UnsupportedRepresentationException("The value given is shorter than the allowed maximum length.");
                }
                if (this.m_maxLength < tempValue.length()) {
                    throw new UnsupportedRepresentationException("The value given is longer than the allowed maximum length.");
                }
            }
            if (!this.isValidAlphabet(tempValue, alphabetRepresentation)) {
                throw new UnsupportedRepresentationException("The value given contains invalid characters.");
            }
            this.m_value = tempValue;
            this.m_alphabet = alphabetRepresentation;
        }
    }

    @Override
    public String getPersistentRepresentation() throws UnsupportedOperationException {
        String s = this.m_value == null ? "null" : (this.m_value.equals("") ? "\"\"" : this.m_value);
        return this.encode("" + s) + ":" + this.m_minLength + ":" + this.m_maxLength + ":" + this.encode("" + this.m_alphabet);
    }

    @Override
    public String getBusinessKey() {
        return this.m_value + ":" + this.m_minLength + ":" + this.m_maxLength;
    }

    @Override
    public void setAllele(Object a_newValue) {
        if (a_newValue != null) {
            String temp = (String)a_newValue;
            if (temp.length() < this.m_minLength || temp.length() > this.m_maxLength) {
                throw new IllegalArgumentException("The given value is too short or too long!");
            }
            if (!this.isValidAlphabet(temp, this.m_alphabet)) {
                throw new IllegalArgumentException("The given value contains at least one invalid character.");
            }
            if (this.getConstraintChecker() != null && !this.getConstraintChecker().verify(this, a_newValue, null, -1)) {
                return;
            }
            this.m_value = temp;
        } else {
            this.m_value = null;
        }
    }

    @Override
    protected Gene newGeneInternal() {
        try {
            StringGene result = new StringGene(this.getConfiguration(), this.m_minLength, this.m_maxLength, this.m_alphabet);
            result.setConstraintChecker(this.getConstraintChecker());
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public int compareTo(Object a_other) {
        StringGene otherStringGene = (StringGene)a_other;
        if (otherStringGene == null) {
            return 1;
        }
        if (otherStringGene.m_value == null) {
            if (this.m_value == null) {
                if (this.isCompareApplicationData()) {
                    return this.compareApplicationData(this.getApplicationData(), otherStringGene.getApplicationData());
                }
                return 0;
            }
            return 1;
        }
        int res = this.m_value.compareTo(otherStringGene.m_value);
        if (res == 0) {
            if (this.isCompareApplicationData()) {
                return this.compareApplicationData(this.getApplicationData(), otherStringGene.getApplicationData());
            }
            return 0;
        }
        return res;
    }

    @Override
    public int size() {
        return this.m_value.length();
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    public int getMinLength() {
        return this.m_minLength;
    }

    public void setMinLength(int m_minLength) {
        this.m_minLength = m_minLength;
    }

    public void setMaxLength(int m_maxLength) {
        this.m_maxLength = m_maxLength;
    }

    public String getAlphabet() {
        return this.m_alphabet;
    }

    public void setAlphabet(String a_alphabet) {
        this.m_alphabet = a_alphabet;
    }

    @Override
    public String toString() {
        String s = "StringGene=";
        s = this.m_value == null ? s + "null" : (this.m_value.equals("") ? s + "\"\"" : s + this.m_value);
        return s;
    }

    public String stringValue() {
        return this.m_value;
    }

    private boolean isValidAlphabet(String a_value, String a_alphabet) {
        if (a_value == null || a_value.length() < 1) {
            return true;
        }
        if (a_alphabet == null) {
            return true;
        }
        if (a_alphabet.length() < 1) {
            return false;
        }
        int length = a_value.length();
        for (int i = 0; i < length; ++i) {
            char c = a_value.charAt(i);
            if (a_alphabet.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyMutation(int index, double a_percentage) {
        char newValue;
        String s = this.stringValue();
        int index2 = -1;
        int len = 0;
        boolean randomize = this.m_alphabet != null ? (len = this.m_alphabet.length()) < 1 : true;
        RandomGenerator rn = this.getConfiguration().getRandomGenerator();
        if (!randomize) {
            int indexC = this.m_alphabet.indexOf(s.charAt(index));
            index2 = indexC + (int)Math.round((double)len * a_percentage);
            if (index2 < 0 || index2 >= len) {
                index2 = rn.nextInt(len);
            }
            newValue = this.m_alphabet.charAt(index2);
        } else {
            index2 = rn.nextInt(256);
            newValue = (char)index2;
        }
        s = s == null ? "" + newValue : s.substring(0, index) + newValue + s.substring(index + 1);
        this.setAllele(s);
    }

    @Override
    protected Object getInternalValue() {
        return this.m_value;
    }
}

