/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.jgap.BaseGeneticOperator;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.impl.IntegerGene;

public class GreedyCrossover
extends BaseGeneticOperator {
    private static final String CVS_REVISION = "$Revision: 1.30 $";
    boolean ASSERTIONS = true;
    private int m_startOffset = 1;

    public GreedyCrossover() throws InvalidConfigurationException {
        super(Genotype.getStaticConfiguration());
    }

    public GreedyCrossover(Configuration a_configuration) throws InvalidConfigurationException {
        super(a_configuration);
    }

    public double distance(Object a_from, Object a_to) {
        IntegerGene from = (IntegerGene)a_from;
        IntegerGene to = (IntegerGene)a_to;
        return Math.abs(to.intValue() - from.intValue());
    }

    @Override
    public void operate(Population a_population, List a_candidateChromosomes) {
        int size = Math.min(this.getConfiguration().getPopulationSize(), a_population.size());
        int numCrossovers = size / 2;
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        for (int i = 0; i < numCrossovers; ++i) {
            IChromosome origChrom1 = a_population.getChromosome(generator.nextInt(size));
            IChromosome firstMate = (IChromosome)origChrom1.clone();
            IChromosome origChrom2 = a_population.getChromosome(generator.nextInt(size));
            IChromosome secondMate = (IChromosome)origChrom2.clone();
            if (this.m_monitorActive) {
                firstMate.setUniqueIDTemplate(origChrom1.getUniqueID(), 1);
                firstMate.setUniqueIDTemplate(origChrom2.getUniqueID(), 2);
                secondMate.setUniqueIDTemplate(origChrom1.getUniqueID(), 1);
                secondMate.setUniqueIDTemplate(origChrom2.getUniqueID(), 2);
            }
            this.operate(firstMate, secondMate);
            a_candidateChromosomes.add(firstMate);
            a_candidateChromosomes.add(secondMate);
        }
    }

    public void operate(IChromosome a_firstMate, IChromosome a_secondMate) {
        Gene[] g1 = a_firstMate.getGenes();
        Gene[] g2 = a_secondMate.getGenes();
        try {
            Gene[] c1 = this.operate(g1, g2);
            Gene[] c2 = this.operate(g2, g1);
            a_firstMate.setGenes(c1);
            a_secondMate.setGenes(c2);
        }
        catch (InvalidConfigurationException cex) {
            throw new Error("Error occured while operating on:" + a_firstMate + " and " + a_secondMate + ". First " + this.m_startOffset + " genes were excluded " + "from crossover. Error message: " + cex.getMessage());
        }
    }

    protected Gene[] operate(Gene[] a_g1, Gene[] a_g2) {
        int i;
        int j;
        int n = a_g1.length;
        LinkedList<Gene> out = new LinkedList<Gene>();
        TreeSet<Gene> not_picked = new TreeSet<Gene>();
        out.add(a_g1[this.m_startOffset]);
        for (j = this.m_startOffset + 1; j < n; ++j) {
            if (this.ASSERTIONS && not_picked.contains(a_g1[j])) {
                throw new Error("All genes must be different for " + this.getClass().getName() + ". The gene " + a_g1[j] + "[" + j + "] occurs more " + "than once in one of the chromosomes. ");
            }
            not_picked.add(a_g1[j]);
        }
        if (this.ASSERTIONS) {
            if (a_g1.length != a_g2.length) {
                throw new Error("Chromosome sizes must be equal");
            }
            for (j = this.m_startOffset; j < n; ++j) {
                if (not_picked.contains(a_g2[j]) || a_g1[this.m_startOffset].equals(a_g2[j])) continue;
                throw new Error("Chromosome gene sets must be identical. First gene set: " + a_g1 + ", second gene set: " + a_g2);
            }
        }
        while (not_picked.size() > 1) {
            Gene other;
            Gene picked;
            boolean pick1;
            Gene last = (Gene)out.getLast();
            Gene n1 = this.findNext(a_g1, last);
            Gene n2 = this.findNext(a_g2, last);
            if (n1 == null) {
                pick1 = false;
            } else if (n2 == null) {
                pick1 = true;
            } else {
                boolean bl = pick1 = this.distance(last, n1) < this.distance(last, n2);
            }
            if (pick1) {
                picked = n1;
                other = n2;
            } else {
                picked = n2;
                other = n1;
            }
            if (out.contains(picked)) {
                picked = other;
            }
            if (picked == null || out.contains(picked)) {
                picked = (Gene)not_picked.first();
            }
            out.add(picked);
            not_picked.remove(picked);
        }
        if (this.ASSERTIONS && not_picked.size() != 1) {
            throw new Error("Given Gene not correctly created (must have length > 1)");
        }
        out.add((Gene)not_picked.last());
        Gene[] g = new Gene[n];
        Iterator gi = out.iterator();
        for (i = 0; i < this.m_startOffset; ++i) {
            g[i] = a_g1[i];
        }
        if (this.ASSERTIONS && out.size() != g.length - this.m_startOffset) {
            throw new Error("Unexpected internal error. These two must be equal: " + out.size() + " and " + (g.length - this.m_startOffset) + ", g.length " + g.length + ", start offset " + this.m_startOffset);
        }
        for (i = this.m_startOffset; i < g.length; ++i) {
            g[i] = (Gene)gi.next();
        }
        return g;
    }

    protected Gene findNext(Gene[] a_g, Gene a_x) {
        for (int i = this.m_startOffset; i < a_g.length - 1; ++i) {
            if (!a_g[i].equals(a_x)) continue;
            return a_g[i + 1];
        }
        return null;
    }

    public void setStartOffset(int a_offset) {
        this.m_startOffset = a_offset;
    }

    public int getStartOffset() {
        return this.m_startOffset;
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        GreedyCrossover op = (GreedyCrossover)a_other;
        if (this.getStartOffset() < op.getStartOffset()) {
            return 1;
        }
        if (this.getStartOffset() > op.getStartOffset()) {
            return -1;
        }
        return 0;
    }
}

