/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.ReadTerminal;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class StoreTerminalIndexed
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private int m_index;
    private Class m_type;

    public StoreTerminalIndexed(GPConfiguration a_conf, int a_index, Class a_childType) throws InvalidConfigurationException {
        this(a_conf, a_index, a_childType, 0, 0);
    }

    public StoreTerminalIndexed(GPConfiguration a_conf, int a_index, Class a_childType, int a_subReturnType, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.VoidClass, a_subReturnType, new int[]{a_subChildType});
        this.m_type = a_childType;
        this.m_index = a_index;
    }

    @Override
    public String toString() {
        return "store(" + this.m_index + ", &1)";
    }

    @Override
    public String getName() {
        return "Store Terminal(" + this.m_index + ")";
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        Object value = null;
        value = this.m_type == CommandGene.IntegerClass ? new Integer(c.execute_int(n, 0, args)) : (this.m_type == CommandGene.LongClass ? new Long(c.execute_long(n, 0, args)) : (this.m_type == CommandGene.DoubleClass ? new Double(c.execute_double(n, 0, args)) : (this.m_type == CommandGene.FloatClass ? new Float(c.execute_float(n, 0, args)) : c.execute(n, 0, args))));
        this.getGPConfiguration().storeIndexedMemory(this.m_index, value);
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int value = c.execute_int(n, 0, args);
        this.getGPConfiguration().storeIndexedMemory(this.m_index, new Integer(value));
        return value;
    }

    @Override
    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        long value = c.execute_long(n, 0, args);
        this.getGPConfiguration().storeIndexedMemory(this.m_index, new Long(value));
        return value;
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        double value = c.execute_double(n, 0, args);
        this.getGPConfiguration().storeIndexedMemory(this.m_index, new Double(value));
        return value;
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        float value = c.execute_float(n, 0, args);
        this.getGPConfiguration().storeIndexedMemory(this.m_index, new Float(value));
        return value;
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        Object value = c.execute_object(n, 0, args);
        this.getGPConfiguration().storeIndexedMemory(this.m_index, value);
        return value;
    }

    @Override
    public boolean isAffectGlobalState() {
        return true;
    }

    @Override
    public boolean isValid(ProgramChromosome a_program) {
        return a_program.getIndividual().getCommandOfClass(0, ReadTerminal.class) > 0;
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return this.m_type;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        StoreTerminalIndexed other = (StoreTerminalIndexed)a_other;
        return new CompareToBuilder().append(this.m_index, other.m_index).append((Object)this.m_type, (Object)other.m_type).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            StoreTerminalIndexed other = (StoreTerminalIndexed)a_other;
            return super.equals(a_other) && new EqualsBuilder().append(this.m_index, other.m_index).append((Object)this.m_type, (Object)other.m_type).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            StoreTerminalIndexed result = new StoreTerminalIndexed(this.getGPConfiguration(), this.m_index, this.m_type, this.getSubReturnType(), this.getSubChildType(0));
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

