/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Modulo
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.10 $";

    public Modulo(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType);
    }

    @Override
    public String toString() {
        return "&1 % &2";
    }

    @Override
    public String getName() {
        return "Modulo";
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        int v1 = c.execute_int(n, 0, args);
        int v2 = c.execute_int(n, 1, args);
        if (v2 == 0) {
            return 0;
        }
        return v1 % v2;
    }

    @Override
    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        long v1 = c.execute_long(n, 0, args);
        long v2 = c.execute_long(n, 1, args);
        if (v2 == 0L) {
            return 0L;
        }
        return v1 % v2;
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        float v1 = c.execute_float(n, 0, args);
        float v2 = c.execute_float(n, 1, args);
        if ((double)Math.abs(v2) < 1.0E-7) {
            return 0.0f;
        }
        return v1 % v2;
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double v1 = c.execute_double(n, 0, args);
        double v2 = c.execute_double(n, 1, args);
        if (Math.abs(v2) < 1.0E-7) {
            return 0.0;
        }
        return v1 % v2;
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        try {
            return ((Compatible)c.execute_object(n, 0, args)).execute_mod(c.execute_object(n, 1, args));
        }
        catch (ArithmeticException aex) {
            throw new IllegalStateException("mod with illegal arguments");
        }
    }

    @Override
    public Object clone() {
        try {
            Modulo result = new Modulo(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_mod(Object var1);
    }
}

