/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class CountMatrix
extends CommandGene
implements ICloneable,
IMutateable {
    private static final String CVS_REVISION = "$Revision: 1.3 $";
    private String m_matrixName;
    private CountType m_countType;
    private CountMode m_countMode;
    private char m_emptyCharacter;
    private char m_specificCharacter;

    public CountMatrix(GPConfiguration a_conf, String a_matrixName, CountType a_countType, CountMode a_countMode, char a_emptyCharacter, char a_specificCharacter) throws InvalidConfigurationException {
        this(a_conf, a_matrixName, a_countType, a_countMode, a_emptyCharacter, a_specificCharacter, 0);
    }

    public CountMatrix(GPConfiguration a_conf, String a_matrixName, CountType a_countType, CountMode a_countMode, char a_emptyCharacter, char a_specificCharacter, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.IntegerClass, 0, new int[]{a_subChildType});
        if (a_matrixName == null || a_matrixName.length() < 1) {
            throw new IllegalArgumentException("Matrix name must not be empty!");
        }
        this.m_matrixName = a_matrixName;
        this.m_countType = a_countType;
        this.m_countMode = a_countMode;
        this.m_emptyCharacter = a_emptyCharacter;
        this.m_specificCharacter = a_specificCharacter;
    }

    @Override
    public String toString() {
        return "countMatrix(" + this.m_matrixName + ", &1)";
    }

    @Override
    public String getName() {
        return "CountMatrix(" + this.m_matrixName + ")";
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        int index = this.m_countType != CountType.MATRIX ? c.execute_int(n, 0, args) : 0;
        char[][] matrix = this.getGPConfiguration().getMatrix(this.m_matrixName);
        int count = 0;
        if (matrix != null) {
            int cols = matrix.length;
            if (index >= cols) {
                index = cols - 1;
            }
            int rows = matrix[index].length;
            switch (this.m_countType) {
                case ROW: {
                    for (int col = 0; col < cols; ++col) {
                        count += this.count(matrix[col][index]);
                    }
                    break;
                }
                case COLUMN: {
                    for (int row = 0; row < rows; ++row) {
                        count += this.count(matrix[index][row]);
                    }
                    break;
                }
                case MATRIX: {
                    for (int col = 0; col < cols; ++col) {
                        for (int row = 0; row < rows; ++row) {
                            count += this.count(matrix[col][row]);
                        }
                    }
                    break;
                }
                case DIAGONAL: {
                    if (cols != rows) {
                        throw new IllegalArgumentException("Cannot count diagonal of the matrix, as the matrix is not square");
                    }
                    if (index < cols / 2) {
                        for (int cell = 0; cell < cols; ++cell) {
                            count += this.count(matrix[cell][cell]);
                        }
                    } else {
                        for (int cell = cols - 1; cell > 0; --cell) {
                            count += this.count(matrix[cell][cell]);
                        }
                    }
                    break;
                }
            }
        }
        return count;
    }

    private int count(char a_char) {
        switch (this.m_countMode) {
            case NONEMPTY: {
                if (a_char != this.m_emptyCharacter) {
                    return 1;
                }
                return 0;
            }
            case EMPTY: {
                if (a_char == this.m_emptyCharacter) {
                    return 1;
                }
                return 0;
            }
            case SPECIFIC: {
                if (a_char == this.m_specificCharacter) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return Integer.class;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        CountMatrix other = (CountMatrix)a_other;
        return new CompareToBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append((Object)this.m_countType, (Object)other.m_countType).append((Object)this.m_countMode, (Object)other.m_countMode).append(this.m_emptyCharacter, other.m_emptyCharacter).append(this.m_specificCharacter, other.m_specificCharacter).append(this.getSubChildTypes(), other.getSubChildTypes()).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            CountMatrix other = (CountMatrix)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append((Object)this.m_countType, (Object)other.m_countType).append((Object)this.m_countMode, (Object)other.m_countMode).append(this.m_emptyCharacter, other.m_emptyCharacter).append(this.m_specificCharacter, other.m_specificCharacter).append(this.getSubChildTypes(), other.getSubChildTypes()).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            CountMatrix result = new CountMatrix(this.getGPConfiguration(), this.m_matrixName, this.m_countType, this.m_countMode, this.m_emptyCharacter, this.m_specificCharacter, this.getSubChildType(0));
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    @Override
    public CommandGene applyMutation(int index, double a_percentage) throws InvalidConfigurationException {
        int type_ = this.getGPConfiguration().getRandomGenerator().nextInt(CountType.values().length);
        int mode = this.getGPConfiguration().getRandomGenerator().nextInt(CountMode.values().length);
        CountMatrix mutant = new CountMatrix(this.getGPConfiguration(), this.m_matrixName, CountType.values()[type_], CountMode.values()[mode], this.m_emptyCharacter, this.m_specificCharacter, this.getSubChildType(0));
        return mutant;
    }

    public static enum CountMode {
        EMPTY(1),
        NONEMPTY(2),
        SPECIFIC(3);

        private int m_value;

        public int intValue() {
            return this.m_value;
        }

        private CountMode(int a_value) {
            this.m_value = a_value;
        }
    }

    public static enum CountType {
        COLUMN(1),
        ROW(2),
        DIAGONAL(3),
        MATRIX(4);

        private int m_value;

        public int intValue() {
            return this.m_value;
        }

        private CountType(int a_value) {
            this.m_value = a_value;
        }
    }
}

