/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class CharacterProvider
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private String m_alphabet;

    public CharacterProvider(GPConfiguration a_conf, Class a_returnType, String a_alphabet) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_alphabet, 0);
    }

    public CharacterProvider(GPConfiguration a_conf, Class a_returnType, String a_alphabet, int a_subReturnType) throws InvalidConfigurationException {
        super(a_conf, 1, a_returnType, a_subReturnType, null);
        if (a_alphabet == null || a_alphabet.length() < 1) {
            throw new IllegalArgumentException("Alphabet must not be empty!");
        }
        this.m_alphabet = a_alphabet;
    }

    @Override
    public String toString() {
        return "character(" + this.m_alphabet + ")";
    }

    @Override
    public String getName() {
        return "Character";
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        int index = c.execute_int(n, 0, args);
        try {
            return Character.valueOf(this.m_alphabet.charAt(index));
        }
        catch (ArrayIndexOutOfBoundsException iex) {
            throw new IllegalStateException("CharacterProvider: child returned invalid index");
        }
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        CharacterProvider other = (CharacterProvider)a_other;
        return new CompareToBuilder().append((Object)this.m_alphabet, (Object)other.m_alphabet).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            CharacterProvider other = (CharacterProvider)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_alphabet, (Object)other.m_alphabet).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            CharacterProvider result = new CharacterProvider(this.getGPConfiguration(), this.getReturnType(), this.m_alphabet, this.getSubReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

