/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPChromosome;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.terminal.Variable;

public abstract class BaseGPChromosome
implements IGPChromosome {
    private static final String CVS_REVISION = "$Revision: 1.8 $";
    private GPConfiguration m_configuration;
    private IGPProgram m_ind;

    public BaseGPChromosome(GPConfiguration a_configuration) throws InvalidConfigurationException {
        if (a_configuration == null) {
            throw new InvalidConfigurationException("Configuration to be set must not be null!");
        }
        this.m_configuration = a_configuration;
    }

    public BaseGPChromosome(GPConfiguration a_configuration, IGPProgram a_ind) throws InvalidConfigurationException {
        this(a_configuration);
        this.m_ind = a_ind;
    }

    @Override
    public IGPProgram getIndividual() {
        return this.m_ind;
    }

    @Override
    public void setIndividual(IGPProgram a_ind) {
        if (a_ind == null) {
            throw new IllegalArgumentException("Individual must not be null");
        }
        this.m_ind = a_ind;
    }

    @Override
    public int getTerminal(int a_index) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            if (functions[j].getArity(this.m_ind) != 0 || --a_index >= 0) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int getFunction(int a_index) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            if (functions[j].getArity(this.m_ind) == 0 || --a_index >= 0) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int getTerminal(int a_index, Class a_type, int a_subType) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            if (a_subType != 0 && functions[j].getSubReturnType() != a_subType || functions[j].getReturnType() != a_type || functions[j].getArity(this.m_ind) != 0 || --a_index >= 0) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int getFunction(int a_index, Class a_type, int a_subType) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            if (functions[j].getReturnType() != a_type || a_subType != 0 && a_subType != functions[j].getSubReturnType() || functions[j].getArity(this.m_ind) == 0 || --a_index >= 0) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int numTerminals() {
        int count = 0;
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int i = 0; i < len && functions[i] != null; ++i) {
            if (functions[i].getArity(this.m_ind) != 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int numFunctions() {
        int count = 0;
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int i = 0; i < len && functions[i] != null; ++i) {
            if (functions[i].getArity(this.m_ind) == 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int numTerminals(Class a_type, int a_subType) {
        int count = 0;
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int i = 0; i < len && functions[i] != null; ++i) {
            if (functions[i].getArity(this.m_ind) != 0 || functions[i].getReturnType() != a_type || a_subType != 0 && functions[i].getSubReturnType() != a_subType) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int numFunctions(Class a_type, int a_subType) {
        int count = 0;
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int i = 0; i < len && functions[i] != null; ++i) {
            if (functions[i].getArity(this.m_ind) == 0 || functions[i].getReturnType() != a_type || a_subType != 0 && functions[i].getSubReturnType() != a_subType) continue;
            ++count;
        }
        return count;
    }

    @Override
    public CommandGene getNode(int a_index) {
        if (a_index >= this.getFunctions().length || this.getFunctions()[a_index] == null) {
            return null;
        }
        return this.getFunctions()[a_index];
    }

    public int getCommandOfClass(int a_n, Class a_class) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            if (functions[j].getClass() != a_class || --a_n >= 0) continue;
            return j;
        }
        return -1;
    }

    public int getAssignableFromClass(int a_n, Class a_class) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            if (!a_class.isAssignableFrom(functions[j].getClass()) || --a_n >= 0) continue;
            return j;
        }
        return -1;
    }

    public int getVariableWithReturnType(int a_n, Class a_returnType) {
        CommandGene[] functions = this.getFunctions();
        int len = functions.length;
        for (int j = 0; j < len && functions[j] != null; ++j) {
            Variable v;
            if (functions[j].getClass() != Variable.class || (v = (Variable)functions[j]).getReturnType() != a_returnType || --a_n >= 0) continue;
            return j;
        }
        return -1;
    }

    @Override
    public GPConfiguration getGPConfiguration() {
        return this.m_configuration;
    }
}

