/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.eval;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.jgap.Population;

public class PopulationHistory
implements Serializable {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private List m_populations = new Vector();
    private int m_maxSize;

    public PopulationHistory(int a_maxSize) {
        if (a_maxSize < 0) {
            throw new IllegalArgumentException("Maximum size must be greater or equal to zero!");
        }
        this.m_maxSize = a_maxSize;
    }

    public Population getPopulation(int a_count) {
        if (a_count >= this.m_populations.size()) {
            return null;
        }
        return (Population)this.m_populations.get(a_count);
    }

    public void addPopulation(Population a_population) {
        if (a_population == null) {
            throw new IllegalArgumentException("Population must not be null");
        }
        this.m_populations.add(0, a_population);
        int popSize = this.m_populations.size();
        if (this.m_maxSize != 0 && popSize > this.m_maxSize) {
            this.m_populations.remove(popSize - 1);
        }
    }

    public void removeAllPopulations() {
        this.m_populations.removeAll(this.m_populations);
    }

    public int size() {
        return this.m_populations.size();
    }

    public List getPopulations() {
        return this.m_populations;
    }

    public void setPopulations(List a_populations) {
        this.m_populations = a_populations;
        int popSize = this.m_populations.size();
        if (this.m_maxSize != 0 && popSize > this.m_maxSize) {
            for (int i = this.m_maxSize; i < popSize; ++i) {
                this.m_populations.remove(this.m_maxSize);
            }
        }
    }

    public boolean equals(Object a_other) {
        PopulationHistory other = (PopulationHistory)a_other;
        for (int i = 0; i < this.size(); ++i) {
            Population pop2;
            Population pop1 = this.getPopulation(i);
            if (pop1.equals(pop2 = other.getPopulation(i))) continue;
            return false;
        }
        return true;
    }
}

