/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr;

import java.io.IOException;
import org.jgap.distr.IWorker;
import org.jgap.distr.MasterInfo;
import org.jgap.distr.RequestDispatcher;
import org.jgap.distr.WorkerCommand;
import org.jgap.distr.WorkerListener;
import org.jgap.util.NetworkKit;

public abstract class Master {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private MasterInfo m_masterinfo;
    private RequestDispatcher m_dispatcher;
    private WorkerListener m_workerListener;

    public Master(RequestDispatcher a_dispatcher, WorkerListener a_workerListener) throws Exception {
        this.m_dispatcher = a_dispatcher;
        this.m_workerListener = a_workerListener;
        this.m_masterinfo = new MasterInfo();
        this.m_masterinfo.m_IPAddress = NetworkKit.getLocalIPAddress();
        this.m_masterinfo.m_name = NetworkKit.getLocalHostName();
    }

    public abstract void start() throws Exception;

    public void stop() {
        this.m_workerListener.stop();
    }

    public MasterInfo getMasterInfo() {
        return this.m_masterinfo;
    }

    public void sendToWorker(IWorker a_worker, WorkerCommand a_command) throws IOException {
        this.m_dispatcher.dispatch(a_worker, a_command);
    }

    public RequestDispatcher getDispatcher() {
        return this.m_dispatcher;
    }

    public WorkerListener getWorkerListener() {
        return this.m_workerListener;
    }
}

