/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.util.List;
import org.jgap.Configuration;
import org.jgap.Population;
import org.jgap.audit.IEvolutionMonitor;
import org.jgap.eval.PopulationHistoryIndexed;

public class TimedMonitor
implements IEvolutionMonitor {
    private static final String CVS_REVISION = "$Revision: 1.5 $";
    private long m_startMillis;
    private int m_seconds;

    public TimedMonitor(int a_seconds) {
        this.m_seconds = a_seconds;
    }

    @Override
    public boolean nextCycle(Population a_pop, List<String> a_messages) {
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - this.m_startMillis >= (long)(this.m_seconds * 1000)) {
            a_messages.add(this.m_seconds + " seconds maximum runtime were reached.");
            return false;
        }
        return true;
    }

    @Override
    public void start(Configuration a_config) {
        this.m_startMillis = System.currentTimeMillis();
    }

    @Override
    public void event(String a_monitorEvent, int a_evolutionNo, Object[] a_information) {
    }

    @Override
    public PopulationHistoryIndexed getPopulations() {
        return null;
    }
}

