/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.util.List;
import org.jgap.Configuration;
import org.jgap.Population;
import org.jgap.audit.IEvolutionMonitor;
import org.jgap.eval.PopulationHistoryIndexed;

public class ChainedMonitors
implements IEvolutionMonitor {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private List<IEvolutionMonitor> m_monitors;
    private int m_positiveMonitorsRequired;

    public ChainedMonitors(List<IEvolutionMonitor> a_monitors, int a_positiveMonitorsRequired) {
        if (a_monitors == null || a_monitors.size() < 1) {
            throw new IllegalArgumentException("Number of monitors must be one or greater!");
        }
        if (a_positiveMonitorsRequired < 1) {
            throw new IllegalArgumentException("Number of positive monitors must be one or greater!");
        }
        if (a_positiveMonitorsRequired > a_monitors.size()) {
            throw new IllegalArgumentException("Number of positive monitors must not be bigger than number of available monitors!");
        }
        this.m_monitors = a_monitors;
        this.m_positiveMonitorsRequired = a_positiveMonitorsRequired;
    }

    @Override
    public boolean nextCycle(Population a_pop, List<String> a_messages) {
        int size = this.m_monitors.size();
        int positive = 0;
        for (IEvolutionMonitor monitor : this.m_monitors) {
            if (monitor.nextCycle(a_pop, a_messages)) {
                if (++positive < this.m_positiveMonitorsRequired) continue;
                return true;
            }
            if (--size + positive >= this.m_positiveMonitorsRequired) continue;
            return false;
        }
        return false;
    }

    @Override
    public void start(Configuration a_config) {
        for (IEvolutionMonitor monitor : this.m_monitors) {
            monitor.start(a_config);
        }
    }

    @Override
    public void event(String a_monitorEvent, int a_evolutionNo, Object[] a_information) {
        for (IEvolutionMonitor monitor : this.m_monitors) {
            monitor.event(a_monitorEvent, a_evolutionNo, a_information);
        }
    }

    @Override
    public PopulationHistoryIndexed getPopulations() {
        return null;
    }

    public List<IEvolutionMonitor> getMonitors() {
        return this.m_monitors;
    }
}

