/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.net;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HashThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Operator;
import org.hecl.StringThing;
import org.hecl.Thing;
import org.hecl.net.HttpRequest;

public class HttpCmd
extends Operator {
    public static final int GETURL = 1;
    public static final int FORMATQUERY = 2;
    public static final int GETDATA = 3;
    public static final int GETNCODE = 4;
    public static final int GETSTATUS = 5;
    public static final String useragentheader = "User-Agent";
    public static final String contentlanguageheader = "Content-Language";
    public static final String defcharset = "ISO8859-1";
    private static String defuseragent = "Hecl http-module";
    private static String deflocale = "en-US";
    private static boolean firsttime = true;
    private static Hashtable cmdtable = new Hashtable();

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        Hashtable h = null;
        boolean validate = false;
        switch (cmd) {
            case 2: {
                if (argv.length % 2 != 1) {
                    throw new HeclException("?key value? ...");
                }
                String[] keyvaluepairs = new String[argv.length - 1];
                for (int i = 1; i < argv.length; ++i) {
                    keyvaluepairs[i - 1] = argv[i].toString();
                }
                return new Thing(HttpRequest.urlencode(keyvaluepairs));
            }
            case 1: {
                int status;
                h = new Hashtable();
                String qdata = null;
                Thing t = null;
                try {
                    t = interp.getVar("http.useragent", 0);
                }
                catch (HeclException heclException) {
                    // empty catch block
                }
                h.put(useragentheader, t != null ? t.toString() : defuseragent);
                if (deflocale != null) {
                    h.put(contentlanguageheader, deflocale);
                }
                for (int i = 2; i < argv.length; i += 2) {
                    String key = argv[i].toString();
                    if (key.equals("-query")) {
                        qdata = argv[i + 1].toString();
                        continue;
                    }
                    if (key.equals("-validate")) {
                        validate = IntThing.get(argv[i + 1]) != 0;
                        continue;
                    }
                    if (key.equals("-binary")) continue;
                    if (key.equals("-headers")) {
                        Vector v = ListThing.get(argv[i + 1]);
                        int n = v.size();
                        for (i = 0; i < n; i += 2) {
                            h.put(((Thing)v.elementAt(i)).toString(), ((Thing)v.elementAt(i + 1)).toString());
                        }
                        continue;
                    }
                    throw new HeclException("Unknown option '" + key + "'.");
                }
                HttpRequest r = new HttpRequest(argv[1].toString(), qdata, validate, h);
                r.start();
                try {
                    Thread.sleep(1L);
                }
                catch (Exception key) {
                    // empty catch block
                }
                if (firsttime) {
                    try {
                        r.join();
                        firsttime = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    while (r.isAlive()) {
                        interp.doOneEvent(-1);
                        Thread.currentThread();
                        Thread.yield();
                    }
                }
                if ((status = r.getStatus()) != 4) {
                    Exception e = r.getException();
                    StringBuffer s = new StringBuffer();
                    s.append("HTTP geturl failed '").append(HttpRequest.getStatusText(status)).append("' - ").append(e != null ? e.toString() : "");
                    System.err.println("msg=" + s.toString());
                    throw new HeclException(s.toString());
                }
                try {
                    int retcode = r.getRC();
                    Hashtable<String, Thing> ht = new Hashtable<String, Thing>();
                    ht.put("status", new Thing(HttpRequest.getStatusText(status)));
                    ht.put("ncode", IntThing.create(retcode));
                    Enumeration e = r.getResponseFieldNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        ht.put(key, new Thing(r.getResponseFieldValue(key)));
                    }
                    ht.put("data", new Thing(new StringThing(r.getBody())));
                    return HashThing.create(ht);
                }
                catch (Exception e) {
                    throw new HeclException(e.getMessage());
                }
            }
            case 3: {
                h = HashThing.get(argv[1]);
                return (Thing)h.get("data");
            }
            case 4: {
                h = HashThing.get(argv[1]);
                return (Thing)h.get("ncode");
            }
            case 5: {
                h = HashThing.get(argv[1]);
                return (Thing)h.get("status");
            }
        }
        throw new HeclException("Unknown http command '" + argv[0].toString() + "' with code '" + cmd + "'.");
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected HttpCmd(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        if (deflocale == null) {
            deflocale = "en-US";
        }
        cmdtable.put("http.geturl", new HttpCmd(1, 1, -1));
        cmdtable.put("http.formatQuery", new HttpCmd(2, 0, -1));
        cmdtable.put("http.data", new HttpCmd(3, 0, -1));
        cmdtable.put("http.ncode", new HttpCmd(4, 0, -1));
        cmdtable.put("http.status", new HttpCmd(5, 0, -1));
    }
}

