/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.java;

import java.util.Enumeration;
import java.util.Vector;
import org.hecl.ClassCommand;
import org.hecl.ClassCommandInfo;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.ObjectThing;
import org.hecl.Thing;
import org.hecl.java.MethodProps;
import org.hecl.java.Reflector;

public class JavaCmd
implements ClassCommand,
Command {
    private static Vector commands = null;
    private String cmdname = null;
    private Class thisclass = null;
    private Reflector classreflector = null;

    public JavaCmd(String clsname) throws HeclException {
        this.classreflector = new Reflector(clsname);
        try {
            this.thisclass = Class.forName(clsname);
        }
        catch (Exception e) {
            throw new HeclException("Error trying to create " + clsname + " : " + e.toString());
        }
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        try {
            String argv1 = argv[1].toString();
            if (argv1.equals("-new")) {
                MethodProps mp = new MethodProps();
                mp.setProps(argv, 1);
                Thing cargs = mp.getProp("-new");
                String thingclass = cargs.getVal().thingclass();
                Thing[] targs = thingclass.equals("list") || thingclass.equals("string") ? ListThing.getArray(cargs) : new Thing[]{cargs};
                mp.delProp("-new");
                Thing newthing = this.classreflector.instantiate(targs);
                mp.evalProps(interp, ObjectThing.get(newthing), this.classreflector);
                return newthing;
            }
            if (argv1.equals("-field")) {
                return this.classreflector.getConstField(argv[2].toString());
            }
            if (argv1.equals("-methods")) {
                return this.classreflector.methods();
            }
            if (argv1.equals("-constructors")) {
                return this.classreflector.constructors();
            }
            return this.classreflector.evaluate(null, argv1, argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HeclException(argv[0].toString() + " " + argv[1].toString() + " error " + e.toString());
        }
    }

    @Override
    public Thing method(Interp interp, ClassCommandInfo context, Thing[] argv) throws HeclException {
        if (argv.length > 1) {
            Object target = ObjectThing.get(argv[0]);
            String subcmd = argv[1].toString().toLowerCase();
            if (subcmd.equals("-field")) {
                if (argv.length == 3) {
                    return this.classreflector.getField(target, argv[2].toString());
                }
                if (argv.length == 4) {
                    this.classreflector.setField(target, argv[2].toString(), argv[3]);
                    return argv[3];
                }
                throw HeclException.createWrongNumArgsException(argv, 2, "fieldname ?fieldvalue?");
            }
            return this.classreflector.evaluate(target, subcmd, argv);
        }
        throw HeclException.createWrongNumArgsException(argv, 2, "Object method [arg...]");
    }

    public Class getCmdClass() {
        return this.thisclass;
    }

    public String getCmdName() {
        return this.cmdname;
    }

    public static void load(Interp ip, String cname, String cmd) throws HeclException {
        if (commands == null) {
            commands = new Vector();
        }
        JavaCmd newjavacmd = new JavaCmd(cname);
        if (cmd != null) {
            ip.addCommand(cmd, newjavacmd);
        }
        ip.addClassCmd(newjavacmd.getCmdClass(), newjavacmd);
        commands.add(newjavacmd);
    }

    public static void unload(Interp ip) {
        Enumeration e = commands.elements();
        while (e.hasMoreElements()) {
            JavaCmd c = (JavaCmd)e.nextElement();
            ip.removeCommand(c.getCmdName());
            ip.removeClassCmd(c.getCmdClass());
        }
    }
}

