/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.files;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.hecl.ClassCommand;
import org.hecl.ClassCommandInfo;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ObjectThing;
import org.hecl.Thing;
import org.hecl.files.HeclChannel;
import org.hecl.files.HeclFileUtils;

public class HeclStreamCmds
implements ClassCommand {
    @Override
    public Thing method(Interp interp, ClassCommandInfo context, Thing[] argv) throws HeclException {
        String subcmd = argv[1].toString().toLowerCase();
        HeclChannel target = (HeclChannel)ObjectThing.get(argv[0]);
        Thing retval = null;
        Thing empty = new Thing("");
        try {
            if (target.readable()) {
                DataInputStream dis = target.datainputstream;
                if (subcmd.equals("close")) {
                    dis.close();
                    retval = empty;
                } else if (subcmd.equals("read")) {
                    if (argv.length == 3) {
                        byte[] b = new byte[IntThing.get(argv[2])];
                        dis.read(b);
                        retval = new Thing(new String(b));
                    } else if (argv.length == 2) {
                        return HeclFileUtils.readFileFromDis(dis);
                    }
                } else if (subcmd.equals("readln")) {
                    StringBuffer sb = new StringBuffer();
                    int c = 0;
                    int last = 0;
                    while (true) {
                        last = c;
                        c = dis.read();
                        if (c == -1 || c == Interp.eol[0] && Interp.eol.length == 1) break;
                        if (Interp.eol.length == 2 && c == Interp.eol[1] && last == Interp.eol[0]) {
                            sb.setLength(sb.length() - 1);
                            break;
                        }
                        sb.append((char)c);
                    }
                    return new Thing(new String(sb));
                }
            }
            if (target.writable()) {
                byte[] bytes;
                DataOutputStream dos = target.dataoutputstream;
                if (subcmd.equals("close")) {
                    dos.close();
                    retval = empty;
                } else if (subcmd.equals("flush")) {
                    dos.flush();
                    retval = empty;
                } else if (subcmd.equals("write")) {
                    bytes = argv[2].toString().getBytes();
                    dos.write(bytes);
                    retval = IntThing.create(bytes.length);
                } else if (subcmd.equals("writeln")) {
                    bytes = argv[2].toString().getBytes();
                    dos.write(bytes);
                    dos.writeByte(Interp.eol[0]);
                    if (Interp.eol.length > 1) {
                        dos.writeByte(Interp.eol[1]);
                    }
                    retval = IntThing.create(bytes.length + Interp.eol.length);
                }
            }
        }
        catch (IOException ioe) {
            throw new HeclException("IOException in " + subcmd + ": " + ioe.toString());
        }
        if (retval == null) {
            throw new HeclException("Bad method for '" + target + "'");
        }
        return retval;
    }

    public static void load(Interp interp) {
        interp.addClassCmd(HeclChannel.class, new HeclStreamCmds());
    }

    public static void unload(Interp interp) {
        interp.removeClassCmd(HeclChannel.class);
    }
}

