/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.Compare;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Operator;
import org.hecl.StringThing;
import org.hecl.Thing;

class StringCmds
extends Operator {
    public static final int APPEND = 1;
    public static final int EQ = 4;
    public static final int NEQ = 5;
    public static final int STRBYTELEN = 7;
    public static final int STRCMP = 8;
    public static final int STRFIND = 9;
    public static final int STRINDEX = 10;
    public static final int STRLAST = 11;
    public static final int STRLEN = 12;
    public static final int STRRANGE = 13;
    public static final int STRREP = 14;
    public static final int STRLOWER = 15;
    public static final int STRUPPER = 16;
    public static final int STRTRIM = 17;
    public static final int STRTRIML = 18;
    public static final int STRTRIMR = 19;
    public static final int STRREPLACE = 20;
    private static Vector defsplitstrings;
    private static String deftrimchars;
    private static Hashtable cmdtable;

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        String str = argv[1].toString();
        StringBuffer sb = null;
        Object s = null;
        String where = null;
        switch (cmd) {
            case 1: {
                Thing result = argv[1];
                sb = new StringBuffer(StringThing.get(result));
                for (int i = 2; i < argv.length; ++i) {
                    sb.append(argv[i].toString());
                }
                StringThing newval = new StringThing(sb);
                result.setCopyVal(newval);
                return new Thing(newval);
            }
            case 4: {
                return new Thing(Compare.same(argv[1], argv[2]) ? IntThing.ONE : IntThing.ZERO);
            }
            case 5: {
                return new Thing(!Compare.same(argv[1], argv[2]) ? IntThing.ONE : IntThing.ZERO);
            }
            case 7: {
                return IntThing.create(str.getBytes().length);
            }
            case 8: {
                return IntThing.create(Compare.compareString(argv[1], argv[2]));
            }
            case 9: {
                where = argv[2].toString();
                return IntThing.create(where.indexOf(argv[1].toString(), argv.length == 4 ? StringCmds.position(where, argv[3]) : 0));
            }
            case 10: {
                if (str.length() <= IntThing.get(argv[2])) {
                    return new Thing("");
                }
                sb = new StringBuffer();
                sb.append(str.charAt(StringCmds.position(str, argv[2])));
                return new Thing(sb);
            }
            case 11: {
                where = argv[2].toString();
                return IntThing.create(where.lastIndexOf(str, argv.length == 4 ? StringCmds.position(where, argv[3]) : where.length() - 1));
            }
            case 12: {
                return IntThing.create(str.length());
            }
            case 13: {
                return new Thing(str.substring(StringCmds.position(str, argv[2]), StringCmds.position(str, argv[3]) + 1));
            }
            case 14: {
                sb = new StringBuffer();
                for (int cnt = IntThing.get(argv[2]); cnt > 0; --cnt) {
                    sb.append(str);
                }
                return new Thing(sb.toString());
            }
            case 15: {
                return new Thing(str.toLowerCase());
            }
            case 16: {
                return new Thing(str.toUpperCase());
            }
            case 17: {
                Vector trimstrings = null;
                if (argv.length != 3) {
                    return new Thing(str.trim());
                }
                trimstrings = ListThing.get(argv[2]);
                String resstr = StringCmds.stripr(str, trimstrings);
                resstr = StringCmds.stripl(resstr, trimstrings);
                return new Thing(resstr);
            }
            case 18: {
                Vector trimstrings = null;
                trimstrings = argv.length == 3 ? ListThing.get(argv[2]) : defsplitstrings;
                String resstr = StringCmds.stripl(str, trimstrings);
                return new Thing(resstr);
            }
            case 19: {
                Vector trimstrings = null;
                trimstrings = argv.length == 3 ? ListThing.get(argv[2]) : defsplitstrings;
                String resstr = StringCmds.stripr(str, trimstrings);
                return new Thing(resstr);
            }
            case 20: {
                String resstr = "";
                Vector v = ListThing.get(argv[1]);
                String original = argv[2].toString();
                String from = ((Thing)v.elementAt(0)).toString();
                String to = ((Thing)v.elementAt(1)).toString();
                int start = original.indexOf(from);
                int idx = 0;
                while (start >= 0) {
                    resstr = resstr + original.substring(idx, start) + to;
                    idx = start + from.length();
                    start = original.indexOf(from, idx);
                }
                resstr = resstr + original.substring(idx, original.length());
                return new Thing(resstr);
            }
        }
        throw new HeclException("Unknown string command '" + argv[1].toString() + "' with code '" + cmd + "'.");
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected StringCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    protected static String stripl(String str, Vector trimstrings) {
        boolean modified = true;
        while (modified) {
            modified = false;
            Enumeration e = trimstrings.elements();
            while (e.hasMoreElements()) {
                String ts = ((Thing)e.nextElement()).toString();
                if (!str.startsWith(ts)) continue;
                str = str.substring(ts.length());
                modified = true;
            }
        }
        return str;
    }

    protected static String stripr(String str, Vector trimstrings) {
        boolean modified = true;
        while (modified) {
            modified = false;
            Enumeration e = trimstrings.elements();
            while (e.hasMoreElements()) {
                String ts = ((Thing)e.nextElement()).toString();
                if (!str.endsWith(ts)) continue;
                str = str.substring(0, str.length() - ts.length());
                modified = true;
            }
        }
        return str;
    }

    protected static int position(String s, Thing what) throws HeclException {
        int len = s.length();
        int pos = IntThing.get(what);
        if (pos > len) {
            pos = len - 1;
        } else if (pos < 0 && (pos += len) < 0) {
            pos = 0;
        }
        return pos;
    }

    static {
        deftrimchars = "\t\n\r\f ";
        cmdtable = new Hashtable();
        defsplitstrings = new Vector();
        defsplitstrings.addElement(new Thing(" "));
        defsplitstrings.addElement(new Thing("\t"));
        defsplitstrings.addElement(new Thing("\n"));
        defsplitstrings.addElement(new Thing("\r"));
        defsplitstrings.addElement(new Thing("\f"));
        cmdtable.put("append", new StringCmds(1, 1, -1));
        cmdtable.put("eq", new StringCmds(4, 2, 2));
        cmdtable.put("ne", new StringCmds(5, 2, 2));
        cmdtable.put("strbytelen", new StringCmds(7, 1, 1));
        cmdtable.put("strcmp", new StringCmds(8, 2, 2));
        cmdtable.put("strfind", new StringCmds(9, 2, 3));
        cmdtable.put("strindex", new StringCmds(10, 2, 2));
        cmdtable.put("strlast", new StringCmds(11, 2, 3));
        cmdtable.put("strlen", new StringCmds(12, 1, 1));
        cmdtable.put("strrange", new StringCmds(13, 3, 3));
        cmdtable.put("strrep", new StringCmds(14, 2, 2));
        cmdtable.put("strlower", new StringCmds(15, 1, 1));
        cmdtable.put("strupper", new StringCmds(16, 1, 1));
        cmdtable.put("strtrim", new StringCmds(17, 1, 2));
        cmdtable.put("strtriml", new StringCmds(18, 1, 2));
        cmdtable.put("strtrimr", new StringCmds(19, 1, 2));
        cmdtable.put("strreplace", new StringCmds(20, 2, 2));
    }
}

