/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.hecl.HeclException;
import org.hecl.Thing;

public class Properties {
    protected Hashtable props = new Hashtable();

    public Properties() {
    }

    public Properties(Object[] defaultprops) {
        for (int i = 0; i < defaultprops.length; i += 2) {
            this.props.put((String)defaultprops[i], (Thing)defaultprops[i + 1]);
        }
    }

    public void setProps(Thing[] argv, int offset) throws HeclException {
        if ((argv.length - offset) % 2 != 0) {
            throw new HeclException("Properties must be name-value pairs");
        }
        for (int i = offset; i < argv.length; i += 2) {
            this.setProp(argv[i].toString(), argv[i + 1]);
        }
    }

    public void setProp(String name, Thing val) {
        this.props.put(name.toLowerCase(), val);
    }

    public Thing getProp(String name) {
        return (Thing)this.props.get(name);
    }

    public Thing getProp(String name, Thing defaultVal) {
        Thing val = this.getProp(name);
        return val == null ? defaultVal : val;
    }

    public boolean existsProp(String name) {
        return this.props.containsKey(name);
    }

    public Thing getAndDelProp(String name) {
        return (Thing)this.props.remove(name);
    }

    public void delProp(String name) {
        this.props.remove(name);
    }

    public Thing[] getProps() {
        int n = this.props.size();
        Thing[] t = new Thing[2 * n];
        Enumeration names = this.props.keys();
        Enumeration vals = this.props.elements();
        int i = 0;
        while (names.hasMoreElements()) {
            t[i++] = new Thing((String)names.nextElement());
            t[i++] = (Thing)vals.nextElement();
        }
        return t;
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }
}

