/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Vector;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Thing;

class Proc
implements Command {
    private Thing code;
    private String[] argnames;
    private int argcount;
    private int refcount = 0;
    private static final String VARARGVARNAME = "args";

    public Proc(Thing cmdvars, Thing cmdcode) throws HeclException {
        this.code = cmdcode;
        Vector varnames = ListThing.get(cmdvars);
        int argc = varnames.size();
        this.argnames = new String[argc];
        for (int i = 0; i < argc; ++i) {
            this.argnames[i] = ((Thing)varnames.elementAt(i)).toString();
        }
        this.argcount = argc > 0 && this.argnames[argc - 1].equals(VARARGVARNAME) ? -argc : argc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        int i;
        Vector<Thing> vargvals = null;
        int argc = this.argcount;
        if (argc < 0) {
            argc = -argc - 1;
            vargvals = new Vector<Thing>();
        }
        if ((i = argv.length - 1) < argc) {
            throw new HeclException("proc " + argv[0] + " doesn't have enough arguments");
        }
        if (i > argc && vargvals == null) {
            throw new HeclException("proc " + argv[0] + " has too many arguments");
        }
        interp.stackIncr();
        ++this.refcount;
        try {
            for (i = 0; i < argc; ++i) {
                interp.setVar(this.argnames[i], argv[i + 1]);
            }
            while (i < argv.length - 1) {
                vargvals.addElement(argv[i + 1]);
                ++i;
            }
            if (vargvals != null) {
                interp.setVar(VARARGVARNAME, ListThing.create(vargvals));
            }
            Thing res = null;
            try {
                res = interp.eval(this.code);
            }
            catch (HeclException e) {
                if (e.code != "RETURN") {
                    throw e;
                }
                res = e.value;
            }
            Thing thing = res;
            return thing;
        }
        finally {
            --this.refcount;
            if (this.refcount > 0) {
                ++interp.cacheversion;
            }
            interp.stackDecr();
        }
    }

    public Thing getCode() {
        return this.code;
    }
}

