/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.CodeThing;
import org.hecl.GroupThing;
import org.hecl.HashThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.ListThing;
import org.hecl.RealThing;
import org.hecl.StringThing;
import org.hecl.SubstThing;
import org.hecl.Thing;

public class PrintThing {
    private static String ws(int n) {
        return new String(new byte[n]).replace('\u0000', ' ');
    }

    public static void printThing(Thing t) throws HeclException {
        PrintThing.printThing(t, 0);
    }

    public static void printThing(Thing t, int depth) throws HeclException {
        RealThing rt = t.getVal();
        if (rt instanceof IntThing) {
            System.out.println(PrintThing.ws(depth * 4) + "INT: " + IntThing.get(t) + " (copy: " + t.copy + ") (literal: " + t.literal + ")");
        } else if (rt instanceof StringThing) {
            System.out.println(PrintThing.ws(depth * 4) + "STR: " + StringThing.get(t) + " (copy: " + t.copy + ")  (literal: " + t.literal + ")");
        } else if (rt instanceof SubstThing) {
            System.out.println(PrintThing.ws(depth * 4) + "SUBST: " + ((SubstThing)rt).getStringRep() + " (copy: " + t.copy + ") (literal: " + t.literal + ")");
        } else if (rt instanceof ListThing) {
            Vector v = ListThing.get(t);
            System.out.println(PrintThing.ws(depth * 4) + "LIST START (copy: " + t.copy + ") (literal: " + t.literal + ")");
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                PrintThing.printThing((Thing)e.nextElement(), depth + 1);
            }
            System.out.println(PrintThing.ws(depth * 4) + "LIST END");
        } else if (rt instanceof GroupThing) {
            Vector v = GroupThing.get(t);
            System.out.println(PrintThing.ws(depth * 4) + "GROUP START " + v.size() + " (copy: " + t.copy + ") (literal: " + t.literal + ")");
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                PrintThing.printThing((Thing)e.nextElement(), depth + 1);
            }
            System.out.println(PrintThing.ws(depth * 4) + "GROUP END");
        } else if (rt instanceof HashThing) {
            Hashtable h = HashThing.get(t);
            System.out.println(PrintThing.ws(depth * 4) + "HASH START (copy: " + t.copy + ") (literal: " + t.literal + ")");
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.out.println(PrintThing.ws(depth * 4) + " KEY: " + key);
                PrintThing.printThing((Thing)h.get(key), depth + 1);
            }
            System.out.println(PrintThing.ws(depth * 4) + "HASH END");
        } else if (rt instanceof CodeThing) {
            System.out.println("CODE:" + t + " (copy: " + t.copy + ") (literal: " + t.literal + ")");
        } else {
            System.out.println("OTHER:" + t + " (copy: " + t.copy + ") (literal: " + t.literal + ")");
        }
    }
}

