/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Operator;
import org.hecl.Thing;

class ListCmds
extends Operator {
    public static final int LIST = 1;
    public static final int LLEN = 2;
    public static final int LINDEX = 3;
    public static final int LINSERT = 4;
    public static final int LSET = 5;
    public static final int LRANGE = 6;
    public static final int LAPPEND = 7;
    public static final int FILTER = 8;
    public static final int SEARCH = 9;
    public static final int JOIN = 10;
    public static final int SPLIT = 11;
    private static Hashtable cmdtable = new Hashtable();

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        int idx = 0;
        int last = 0;
        ListThing newval = null;
        switch (cmd) {
            case 1: {
                Vector<Thing> result = new Vector<Thing>();
                for (int i = 1; i < argv.length; ++i) {
                    result.addElement(argv[i]);
                }
                return ListThing.create(result);
            }
            case 2: {
                Vector list = ListThing.get(argv[1]);
                return IntThing.create(list.size());
            }
            case 3: {
                Thing res = argv[1];
                for (int i = 2; i < argv.length; ++i) {
                    Vector list = ListThing.get(res);
                    last = list.size();
                    idx = ListCmds.getIndex(argv[i], last);
                    if (idx >= last) {
                        list = new Vector();
                        res = ListThing.create(list);
                        continue;
                    }
                    res = (Thing)list.elementAt(idx);
                }
                return res;
            }
            case 4: {
                Vector list = ListThing.get(argv[1]);
                list.insertElementAt(argv[3], ListCmds.getIndex(argv[2], list.size()));
                newval = new ListThing(list);
                argv[1].setCopyVal(newval);
                return new Thing(newval);
            }
            case 5: {
                Vector list = ListThing.get(argv[1]);
                idx = ListCmds.getIndex(argv[2], list.size());
                if (argv.length < 4) {
                    list.removeElementAt(idx);
                } else {
                    list.setElementAt(argv[3], idx);
                }
                newval = new ListThing(list);
                argv[1].setCopyVal(newval);
                return new Thing(newval);
            }
            case 6: {
                Vector list = ListThing.get(argv[1]);
                int ls = list.size();
                int first = ListCmds.getIndex(argv[2], ls);
                last = ListCmds.getIndex(argv[3], ls);
                if (last < first || first > ls) {
                    return Thing.emptyThing();
                }
                Vector result = new Vector();
                for (int i = first; i <= last; ++i) {
                    result.addElement(list.elementAt(i));
                }
                return ListThing.create(result);
            }
            case 7: {
                Vector list = ListThing.get(argv[1]);
                for (int i = 2; i < argv.length; ++i) {
                    list.addElement(argv[i]);
                }
                newval = new ListThing(list);
                argv[1].setCopyVal(newval);
                return new Thing(newval);
            }
            case 8: 
            case 9: {
                Vector list = ListThing.get(argv[1]);
                Vector<Thing> result = new Vector<Thing>();
                String varname = argv[2].toString();
                int sz = list.size();
                boolean brk = false;
                if (cmd == 9) {
                    brk = true;
                }
                for (int i = 0; i < sz; ++i) {
                    Thing val = (Thing)list.elementAt(i);
                    val.copy = true;
                    interp.setVar(varname, val);
                    if (IntThing.get(interp.eval(argv[3])) == 0) continue;
                    result.addElement(val);
                    if (brk) break;
                }
                return ListThing.create(result);
            }
            case 10: {
                Vector list = ListThing.get(argv[1]);
                StringBuffer strres = new StringBuffer("");
                boolean firstone = true;
                String joinstr = null;
                joinstr = argv.length > 2 ? argv[2].toString() : " ";
                Enumeration e = list.elements();
                while (e.hasMoreElements()) {
                    if (!firstone) {
                        strres.append(joinstr);
                    } else {
                        firstone = false;
                    }
                    strres.append(((Thing)e.nextElement()).toString());
                }
                return new Thing(strres);
            }
            case 11: {
                String str = argv[1].toString();
                String splitstr = null;
                if (argv.length > 2) {
                    splitstr = argv[2].toString();
                }
                return ListThing.stringSplit(str, splitstr);
            }
        }
        throw new HeclException("Unknown list command '" + argv[0].toString() + "' with code '" + cmd + "'.");
    }

    public static int getIndex(Thing t, int llen) throws HeclException {
        String s = t.toString();
        if (s.equals("end")) {
            return llen - 1;
        }
        if (s.equals("start")) {
            return 0;
        }
        int idx = IntThing.get(t);
        if (idx < 0 && (idx += llen) < 0) {
            idx = 0;
        }
        return idx;
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected ListCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        cmdtable.put("list", new ListCmds(1, -1, -1));
        cmdtable.put("llen", new ListCmds(2, 1, 1));
        cmdtable.put("llength", new ListCmds(2, 1, 1));
        cmdtable.put("lappend", new ListCmds(7, 1, -1));
        cmdtable.put("lindex", new ListCmds(3, 2, -1));
        cmdtable.put("linsert", new ListCmds(4, 3, 3));
        cmdtable.put("lset", new ListCmds(5, 2, 3));
        cmdtable.put("lrange", new ListCmds(6, 3, 3));
        cmdtable.put("filter", new ListCmds(8, 2, 3));
        cmdtable.put("search", new ListCmds(9, 2, 3));
        cmdtable.put("join", new ListCmds(10, 1, 2));
        cmdtable.put("split", new ListCmds(11, 1, 2));
    }
}

