/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtikz;

import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sf.jtikz.AbstractGraphicsInterface;
import net.sf.jtikz.GraphicsCommand;

public class TikzGraphics2D
extends AbstractGraphicsInterface {
    public static final String VERSION = "0.1";
    public static final String REV_DATE = "2009-10-18";
    Hashtable<Color, String> colors = new Hashtable();
    String preamble = "";
    int colorId = 0;

    public TikzGraphics2D() {
        this(null);
    }

    public TikzGraphics2D(OutputStream os) {
        super(os);
    }

    @Override
    protected TikzGraphics2D newInstance() {
        return new TikzGraphics2D();
    }

    protected String colorToTikz(Color color) {
        if (this.getParent() != null) {
            return ((TikzGraphics2D)this.getParent()).colorToTikz(color);
        }
        String s = this.colors.get(color);
        if (s == null) {
            this.preamble = this.preamble + "\\definecolor{color" + this.colorId + "}{rgb}{" + (double)color.getRed() / 255.0 + "," + (double)color.getGreen() / 255.0 + "," + (double)color.getBlue() / 255.0 + "}\n";
            s = "color" + this.colorId++ + (color.getAlpha() < 255 ? ",opacity=" + (double)color.getAlpha() / 255.0 : "");
            this.colors.put(color, s);
        }
        return s;
    }

    String handleOptions() {
        return this.handleOptions("");
    }

    String handleOptions(String options) {
        return this.handleOptions(options, false);
    }

    void addOption(StringBuffer oldOptions, String newOption) {
        if (!oldOptions.toString().equals("") && !newOption.equals("")) {
            oldOptions.append(", ");
        }
        oldOptions.append(newOption);
    }

    String handleOptions(String options, boolean isText) {
        StringBuffer o = new StringBuffer(options);
        if (!this.color.equals(Color.BLACK)) {
            this.addOption(o, (isText ? "text=" : "") + this.colorToTikz(this.color));
        }
        if (this.color.getAlpha() != 255) {
            this.addOption(o, (isText ? "text " : "") + "opacity=" + (double)this.color.getAlpha() / 255.0);
        }
        if (this.stroke.getDashArray() != null && this.stroke.getDashArray().length > 1) {
            this.addOption(o, "dashed");
        }
        if ((double)this.stroke.getLineWidth() != 1.0) {
            this.addOption(o, "line width=" + this.stroke.getLineWidth() + "pt");
        }
        if (o.toString().equals("")) {
            return "";
        }
        return "[" + o + "]";
    }

    public String toTeX(String s) {
        return s.replaceAll("\n", "\\\\").replaceAll("&", "\\&").replaceAll("#", "\\#");
    }

    @Override
    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        ColorModel c = image.getColorModel();
        Raster r = image.getData();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
            }
        }
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        img.getSource().startProduction(new PixelConsumer(img, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        return true;
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    @Override
    protected void handleDrawString(String s, double x, double y) {
        this.addCommand("\\node" + this.handleOptions("anchor=south west", true) + " at (" + x + "pt, " + y + "pt) {" + this.toTeX(s) + "};");
    }

    @Override
    protected void handlePath(PathIterator i, AbstractGraphicsInterface.Action action) {
        this.handlePathInternal(i, action);
    }

    String handlePathInternal(PathIterator i, AbstractGraphicsInterface.Action action) {
        double[] s = new double[6];
        String tikz = "";
        tikz = action.equals((Object)AbstractGraphicsInterface.Action.CLIP) ? tikz + "\\path[clip]" : tikz + "\\" + (action.equals((Object)AbstractGraphicsInterface.Action.FILL) ? "fill" : "draw") + this.handleOptions();
        while (!i.isDone()) {
            int type = i.currentSegment(s);
            i.next();
            switch (type) {
                case 1: {
                    tikz = tikz + " --";
                }
                case 0: {
                    tikz = tikz + " (" + s[0] + "pt, " + s[1] + "pt)";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    tikz = tikz + " .. (" + s[0] + "pt, " + s[1] + "pt) and (" + s[2] + "pt, " + s[3] + "pt) .. (" + s[4] + "pt, " + s[5] + "pt)";
                    break;
                }
                case 4: {
                    tikz = tikz + " -- cycle";
                }
            }
        }
        tikz = tikz + ";";
        if (!action.equals((Object)AbstractGraphicsInterface.Action.CLIP)) {
            this.addCommand(tikz);
        }
        return tikz;
    }

    @Override
    protected void handleLine(double x1, double y1, double x2, double y2) {
        this.addCommand("\\draw" + this.handleOptions() + " (" + x1 + "pt, " + y1 + "pt) -- (" + x2 + "pt, " + y2 + "pt);");
    }

    @Override
    protected void handleOval(double x, double y, double width, double height, boolean fill) {
        double rw = width / 2.0;
        double rh = height / 2.0;
        double cx = x + rw;
        double cy = y + rh;
        this.addCommand("\\" + (fill ? "fill" : "draw") + this.handleOptions() + " (" + cx + "pt, " + cy + "pt) ellipse (" + rw + "pt and " + rh + "pt);");
    }

    @Override
    protected void handleArc(double x, double y, double width, double height, int startAngle, int arcAngle, boolean fill) {
        double radiusx = width / 2.0;
        double radiusy = height / 2.0;
        double centerx = x + radiusx;
        double centery = y + radiusy;
        double startx = centerx + radiusx * Math.cos(Math.toRadians(-startAngle));
        double starty = centery + radiusy * Math.sin(Math.toRadians(-startAngle));
        this.addCommand("\\" + (fill ? "fill" : "draw") + this.handleOptions() + " (" + centerx + "pt, " + centery + "pt) -- (" + startx + "pt, " + starty + "pt) arc (" + -startAngle + ":" + (-startAngle - arcAngle) + ":" + radiusx + "pt and " + radiusy + "pt) -- cycle;");
    }

    @Override
    protected void flushInternal() {
        if (this.preamble != null && !this.preamble.equals("") || this.getCommands() != null && !this.getCommands().isEmpty()) {
            this.out.print(this.preamble);
            this.out.println("\\begin{tikzpicture}[yscale=-1]");
            this.setClip(null);
            int indent = 1;
            Shape lastClip = null;
            String tikz = "";
            for (GraphicsCommand c : this.commands) {
                int i;
                if (c.getClip() != lastClip && !c.getClip().equals(lastClip)) {
                    while (indent > 1) {
                        --indent;
                        for (i = 0; i < indent; ++i) {
                            this.out.print("  ");
                        }
                        this.out.println("\\end{scope}");
                    }
                    for (i = 0; i < indent; ++i) {
                        this.out.print("  ");
                    }
                    this.out.println("\\begin{scope}");
                    ++indent;
                    for (i = 0; i < indent; ++i) {
                        this.out.print("  ");
                    }
                    this.out.print(this.handlePathInternal(c.getClip().getPathIterator(this.transform), AbstractGraphicsInterface.Action.CLIP));
                    lastClip = c.clip;
                }
                for (i = 0; i < indent; ++i) {
                    this.out.print("  ");
                }
                this.out.println(c.command);
            }
            while (indent > 1) {
                --indent;
                for (int i = 0; i < indent; ++i) {
                    this.out.print("  ");
                }
                this.out.println("\\end{scope}");
            }
            this.out.println("\\end{tikzpicture}");
        }
        this.preamble = "";
        this.colorId = 0;
        this.colors = new Hashtable();
    }

    @Override
    protected void handlePolyline(double[] xPoints, double[] yPoints, int nPoints) {
        String tikz = "";
        tikz = tikz + "\\draw (" + xPoints[0] + "pt, " + yPoints[0] + "pt)";
        for (int i = 1; i < nPoints; ++i) {
            tikz = tikz + " -- (" + xPoints[i] + "pt, " + yPoints[i] + "pt)";
        }
        tikz = tikz + ";";
        this.addCommand(tikz);
    }

    @Override
    protected void handleRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight, boolean fill) {
        String tikz = "";
        double angle = (arcWidth + arcHeight) / 2.0;
        String options = "";
        if (angle != 0.0) {
            options = "rounded corners =" + angle + "pt";
        }
        tikz = tikz + "\\" + (fill ? "fill" : "draw") + this.handleOptions(options) + " (" + x + "pt, " + y + "pt) -- (" + (x + width - 1.0) + "pt, " + y + "pt) -- (" + (x + width - 1.0) + "pt, " + (y + height - 1.0) + "pt) -- (" + x + "pt, " + (y + height - 1.0) + "pt) -- cycle;";
        this.addCommand(tikz);
    }

    @Override
    protected void handleClearRect(double x, double y, double width, double height) {
        this.addCommand("\\fill[" + this.colorToTikz(this.background) + "] (" + x + "pt, " + y + "pt) -- (" + (x + width - 1.0) + "pt, " + y + "pt) -- (" + (x + width - 1.0) + "pt, " + (y + height - 1.0) + "pt) -- (" + x + "pt, " + (y + height - 1.0) + "pt) -- cycle;");
    }

    private class PixelConsumer
    extends PixelGrabber {
        public PixelConsumer(Image img, int x, int y, int w, int h, boolean forceRGB) {
            super(img, x, y, w, h, forceRGB);
        }

        public void handlesinglepixel(int x, int y, int pixel) {
            int alpha = pixel >> 24 & 0xFF;
            int red = pixel >> 16 & 0xFF;
            int green = pixel >> 8 & 0xFF;
            int blue = pixel & 0xFF;
            TikzGraphics2D.this.addCommand("{\\pgfsys@color@rgb{" + (double)red / 255.0 + "}{" + (double)green / 255.0 + "}{" + (double)blue / 255.0 + "}\\fill (" + ((double)x - 0.5) + "pt, " + ((double)y - 0.5) + "pt) rectangle (" + ((double)x + 0.5) + "pt, " + ((double)y + 0.5) + "pt);}");
        }
    }
}

