/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtikz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class JTikzIcon
extends BufferedImage
implements Icon {
    Font serif = null;
    Font italic = null;
    int w1;
    int w2;
    int w3;
    int stringHeight;
    int maxDescent;

    public JTikzIcon(int width, int height) {
        super(width, height, 1);
        Graphics2D g = this.createGraphics();
        int size = 1;
        while (true) {
            int w3;
            int w2;
            Font serif = new Font("Serif", 0, size);
            FontMetrics sm = g.getFontMetrics(serif);
            Font italic = new Font("Serif", 2, size);
            FontMetrics im = g.getFontMetrics(italic);
            int w1 = sm.stringWidth("JTi");
            if (w1 + (w2 = im.stringWidth("k")) + (w3 = sm.stringWidth("Z")) > width && this.serif != null) break;
            this.serif = serif;
            this.italic = italic;
            this.w1 = w1;
            this.w2 = w2;
            this.w3 = w3;
            this.stringHeight = Math.max(sm.getHeight(), im.getHeight());
            this.maxDescent = Math.max(sm.getMaxDescent(), im.getMaxDescent());
            ++size;
        }
        this.paint(g);
    }

    public void paint(Graphics graphics) {
        this.paintIcon(null, graphics, 0, 0);
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    private int round(double n) {
        return (int)(n + 0.5);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        int height = this.getHeight();
        int width = this.getWidth() - 1;
        int stringWidth = this.w1 + this.w2 + this.w3;
        if (graphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setColor(Color.WHITE);
        graphics.fillRect(x, y, width, height);
        graphics.setColor(Color.BLACK);
        graphics.setFont(this.serif);
        graphics.drawString("JTi", x + (width - stringWidth) / 2, y - this.maxDescent + height - (height - this.stringHeight) / 2);
        graphics.drawString("Z", x + (width - stringWidth) / 2 + this.w1 + this.w2, y - this.maxDescent + height - (height - this.stringHeight) / 2);
        graphics.setFont(this.italic);
        graphics.drawString("k", x + (width - stringWidth) / 2 + this.w1, y - this.maxDescent + height - (height - this.stringHeight) / 2);
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Test!");
        frame.getContentPane().setPreferredSize(new Dimension(640, 480));
        frame.getContentPane().add(new JLabel(new JTikzIcon(32, 32)));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

